/*----------------------------------------------------------------------------
--
--  Module:           xitError
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xitError.c.
--
--  Filename:         xitError.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-08-19
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/


/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitError.h, Version: 1.1, Date: 95/02/18 15:10:29 */


/* Include this module only once. */
#ifndef define_xitError_h
#  define define_xitError_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Types of messages. */
typedef enum {
  XIT_ER_FATAL, XIT_ER_ERROR, XIT_ER_INFO
} XIT_ER_MESSAGE_TYPE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xitErMessage( Widget               parent,
                XIT_ER_MESSAGE_TYPE  message_type,
                char                 *module,
                char                 *location,
                char                 *message_str );

void
  xitErSetApplicationName( char  *name );

#endif
