/*----------------------------------------------------------------------------
--
--  Module:           xitCreTb
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Creates a toggle button widget.
--
--  Filename:         xitCreTb.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitCreTb.c, Version: 1.1, Date: 95/02/18 15:10:26";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/ToggleB.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreateToggleButton( Widget   parent,
                         char     *name,
                         char     *label,
                         Boolean  set )
{

  /* Variables. */
  Arg       args[ 10 ];
  Cardinal  n;
  Widget    w;
  XmString  xstr = NULL;


  /* Code. */

  n = 0;
  if( strlen( label ) > 0 ) {
    xstr = XmStringCreateLtoR( label, CS );
    XtSetArg( args[ n ], XmNlabelString, xstr ); n++;
  }

  XtSetArg( args[ n ], XmNalignment, XmALIGNMENT_CENTER ); n++;

  if( set ) {
    XtSetArg( args[ n ], XmNset, True ); n++;
  }

  w = XmCreateToggleButton( parent, name, args, n );

  if( strlen( label ) > 0 )
    XmStringFree( xstr );

  return( w );

} /* xitCreateToggleButton */
