/*----------------------------------------------------------------------------
--
--  Module:           XmUbTimeSlider
--
--  Project:          XmUb - Ulle's Motif widgets
--  System:           
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This is the private header file for the widget.
--
--  Filename:         XmUbTimeSlP.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-09-21
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: XmUbTimeSlP.h, Version: 1.1, Date: 95/02/18 15:10:17 */

#ifndef _XmUbTimeSlP_h
#define _XmUbTimeSlP_h

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <X11/StringDefs.h>
#include <Xm/XmP.h>

#if XmVersion > 1001
#include "Xm/ManagerP.h"
#endif

#include "XmUbTimeSl.h"

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Indices for widgets in the internal children array. */

#define NO_INTERNAL_CHILDREN  ( XmUbTS_LAST_CHILD + 1 )

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* CLASS RECORD */

typedef struct {

  XtPointer  extension;

} XmUbTimeSliderClassPart;


/* Full class record declaration. */

typedef struct {

  CoreClassPart             core_class;
  CompositeClassPart        composite_class;
  ConstraintClassPart       constraint_class;
  XmManagerClassPart        manager_class;
  XmUbTimeSliderClassPart   timeslider_class;

} XmUbTimeSliderClassRec;


/* INSTANCE RECORD */

typedef struct {

  /* RESOURCES. */
  /* Callbacks. */
  XtCallbackList    activate_callback;
  XtCallbackList    value_changed_callback;

  /* Offsets and spacings. */
  Dimension         slider_spacing;
  Dimension         text_spacing;
  Dimension         margin_height;
  Dimension         margin_width;

  /* Size computation. */
  Boolean           recompute_width;
  Boolean           recompute_height;

  /* PRIVATE STATE. */
  /* Internal widgets. Some may be NULL depending on format. */
  Widget    internal_children[ NO_INTERNAL_CHILDREN ];
  
  Boolean   resize_called;  /* Because unclear widget set philosophy. */

  Boolean   internal_widgets_created;

} XmUbTimeSliderPart;

/* Full instance record declaration. */

typedef struct _XmUbTimeSliderRec {

  CorePart            core;
  CompositePart       composite;
  ConstraintPart      constraint;
  XmManagerPart       manager;
  XmUbTimeSliderPart  sl;

} XmUbTimeSliderRec;



/* Constraint record for the children of this widget. */
typedef struct {

  XtPointer  extension;

} XmUbTimeSliderConstraintsPart;


typedef struct {

  XmManagerConstraintPart        manager;
  XmUbTimeSliderConstraintsPart  sl;

} XmUbTimeSliderConstraintsRec, *XmUbTimeSliderConstraints;

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Conventional declaration. */
extern XmUbTimeSliderClassRec xmUbTimeSliderClassRec;

/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

#endif
