/*----------------------------------------------------------------------------
--
--  Module:           Standard
--
--  Project:          Tools
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Standard type definitions and declarations.
--
--  Filename:         Standard.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: Standard.h, Version: 1.1, Date: 95/02/18 14:32:30 */


/* Include only once. */
#ifndef Standard_h
#  define Standard_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Boolean operations. */
#ifndef True
#  define True 1
#endif

#ifndef False
#  define False 0
#endif

#ifndef Boolean
#  define Boolean  char
#endif


/* Set, test and clear flags. */
#define flagClear( flags, mask ) ((flags) = ((flags) & (~mask)))
#define flagIsClear( flags, mask ) ((((flags) & (mask)) == 0) ? True : False)
#define flagIsSet( flags, mask ) ((((flags) & (mask)) != 0) ? True : False)
#define flagSet(   flags, mask ) ((flags) = ((flags) | (mask)))


/* Short name for Motif default character set. */
#define CS    ((XmStringCharSet) XmSTRING_DEFAULT_CHARSET)

/* Short name for the standard writing direction. */
#define SD    XmSTRING_DIRECTION_L_TO_R


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Declarations of various standard types. */
typedef int                INT32;
typedef unsigned int       UINT32;
typedef short int          INT16;
typedef unsigned short int UINT16;
typedef char               INT8;
typedef unsigned char      UINT8;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

#endif
