/*----------------------------------------------------------------------------
--
--  Module:           xtmShowToDo
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmShowToDo.
--
--  Filename:         xtmShowToDo.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-01-24
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmShowToDo.h, Version: 1.1, Date: 95/02/18 15:52:52 */


/* Include this module only once. */
#ifndef define_xtmShowToDo_h
#  define define_xtmShowToDo_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "TimDate.h"

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_SD_REASON_DESTROY
} XTM_SD_REASON;

/* Handle to use when comminucating with the summary window. */
typedef  void  *XTM_SD_HANDLE;

/* Callback when the summary window is destroyed. */
typedef void ( *XTM_SD_ACTION_CB ) ( XTM_SD_REASON, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmSdDestroy( XTM_SD_HANDLE  show_handle );

void 
  xtmSdDisplaySummary( XTM_SD_HANDLE  show_handle,
                       TIM_TIME_REF   from_date,
                       TIM_TIME_REF   to_date,
                       char           *search_tags );

void
  xtmSdEmptyCache();

XTM_SD_HANDLE
  xtmSdInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                toplevel,
                   char                  *db_name,
                   XTM_SD_ACTION_CB      actionCB,
                   void                  *user_data );

#endif
