/*----------------------------------------------------------------------------
--
--  Module:           xtmSelHidden
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmSelHidden.
--
--  Filename:         xtmSelHidden.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-08-15
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmSelHidden.h, Version: 1.1, Date: 95/02/18 15:52:48 */


/* Include this file only once. */
#ifndef define_xtmSelectHidden_h
#  define define_xtmSelectHidden_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_SH_REASON_APPLY,
  XTM_SH_REASON_CLOSE,
  XTM_SH_REASON_DESTROY,
  XTM_SH_REASON_EDIT
} XTM_SH_REASON;

/* Handle to use when comminucating with the select window. */
typedef  void  *XTM_SH_HANDLE;

/* Callback. */
typedef void ( *XTM_SH_ACTION_CB ) (XTM_SH_REASON, 
                                    UINT32, char *,
                                    TIM_TIME_REF, TIM_TIME_REF,
                                    void *);


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmShDestroy( XTM_SH_HANDLE  sel_handle );

void
  xtmShDisplaySelectWindow( XTM_SH_HANDLE  sel_handle,
                            char           *select_from_cal,
                            TIM_TIME_REF   start_at_date );

XTM_SH_HANDLE
  xtmShInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   Boolean               app_modal,
                   XTM_SH_ACTION_CB      actionCB,
                   void                  *user_data );

#endif
