/*----------------------------------------------------------------------------
--
--  Module:           xtmIcons
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Icon management in XDiary.
--
--  Filename:         xtmIcons.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-04-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xtmIcons.c, Version: 1.1, Date: 95/02/18 15:52:25";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Intrinsic.h>

#include "System.h"

#include "xitTools.h"
#include "xtmIcons.h"

#include "xtmAclIcon.bm"
#include "xtmAlarmClock1.bm"
#include "xtmAlarmClock2.bm"
#include "xtmAlarmClock3.bm"
#include "xtmAlarmClock4.bm"
#include "xtmAlarmClock5.bm"
#include "xtmAlarmClock5Inv.bm"
#include "xtmAlarmClock6.bm"
#include "xtmAlarmClock7.bm"
#include "xtmAlarmClock8.bm"
#include "xtmAlarmClock9.bm"
#include "xtmAppEditIcon.bm"
#include "xtmCalendarIcon.bm"
#include "xtmCalTop.bm"
#include "xtmCalLeftTop.bm"
#include "xtmCalRightTop.bm"
#include "xtmCustIcon.bm"
#include "xtmDefaultIcon.bm"
#include "xtmDropMenu.bm"
#include "xtmMailIcon.bm"
#include "xtmMessageIcon.bm"
#include "xtmMoveAnimate.bm"
#include "xtmMoveAnimate1.bm"
#include "xtmMoveAnimate2.bm"
#include "xtmMoveAnimate3.bm"
#include "xtmMoveAnimate4.bm"
#include "xtmMoveAnimate5.bm"
#include "xtmMoveAnimate6.bm"
#include "xtmNavCalIcon.bm"
#include "xtmPlannerIcon.bm"
#include "xtmPrintIcon.bm"
#include "xtmReminderIcon.bm"
#include "xtmScheduleIcon.bm"
#include "xtmSummaryIcon.bm"
#include "xtmXdiaryLogo.bm"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Name of module. */
static char  *module_name = "xtmIcons";


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void
  fetchIconInfo( XTM_IC_ICON_TYPE  icon_type,
                 unsigned char     **bits,
                 int               *width,
                 int               *height );



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Pixmap
  xtmIcFetchSimplePixmap( Widget            colorTemplW,
                          XTM_IC_ICON_TYPE  icon_type,
                          Boolean           invert )
{

  /* Variables. */
  int            height;
  int            width;
  unsigned char  *bits;
  Arg            args[ 10 ];
  Cardinal       n;
  Pixel          background;
  Pixel          foreground;
  Pixmap         pixmap;


  /* Code. */

  /* Fetch icon information. */
  fetchIconInfo( icon_type, &bits, &width, &height );


  /* Make sure we get a foreground. */
  if( invert )
    foreground = WhitePixelOfScreen( XtScreen( colorTemplW ) );
  else
    foreground = BlackPixelOfScreen( XtScreen( colorTemplW ) );

  /* Color for the icon. */
  n = 0;
  if( invert ) {
    XtSetArg( args[ n ], XmNbackground, &foreground ); n++;
    XtSetArg( args[ n ], XmNforeground, &background ); n++;
  } else {
    XtSetArg( args[ n ], XmNbackground, &background ); n++;
    XtSetArg( args[ n ], XmNforeground, &foreground ); n++;
  }
  XtGetValues( colorTemplW, args, n );


  /* Create icon pixmap. */
  pixmap = XCreatePixmapFromBitmapData( 
             XtDisplay( colorTemplW ),
             RootWindowOfScreen( XtScreen( colorTemplW ) ),
             (char *) bits, width, height,
             foreground, background,
             DefaultDepthOfScreen( XtScreen( colorTemplW ) ) );


  return( pixmap );

} /* xtmIcFetchSimplePixmap */


/*----------------------------------------------------------------------*/

void
  xtmIcSetSimpleIcon( Widget            iconForW,
                      Widget            colorTemplW,
                      XTM_IC_ICON_TYPE  icon_type )
{

  /* Variables. */
  int              height;
  int              width;
  unsigned char    *bits;
  Arg              args[ 10 ];
  Cardinal         n;
  Pixel            background;
  Pixel            foreground;
  Pixmap           pixmap;
  Window           dummy_win;
  GC               dummy_gc;
  XIT_ICON_WINDOW  icon_win;


  /* Code. */

  /* Fetch icon information. */
  fetchIconInfo( icon_type, &bits, &width, &height );


  /* Make sure we get a foreground. */
  foreground = BlackPixelOfScreen( XtScreen( colorTemplW ) );

  /* Color for the icon. */
  n = 0;
  XtSetArg( args[ n ], XmNbackground, &background ); n++;
  XtSetArg( args[ n ], XmNforeground, &foreground ); n++;
  XtGetValues( colorTemplW, args, n );


  /* Create icon pixmap. */
  pixmap = XCreatePixmapFromBitmapData( 
             XtDisplay( colorTemplW ),
             RootWindowOfScreen( XtScreen( colorTemplW ) ),
             (char *) bits, width, height,
             foreground, background,
             DefaultDepthOfScreen( XtScreen( colorTemplW ) ) );

  icon_win.image                = pixmap;
  icon_win.icon_fg              = foreground;
  icon_win.icon_bg              = background;
  icon_win.report_expose_events = False;
  icon_win.x_offset             = 0;
  icon_win.y_offset             = 0;
  icon_win.label                = NULL;

  xitSetIconWindow( iconForW, &icon_win, &dummy_win, &dummy_gc );


  return;

} /* xtmIcSetSimpleIcon */


/*----------------------------------------------------------------------*/

static void
  fetchIconInfo( XTM_IC_ICON_TYPE  icon_type,
                 unsigned char     **bits,
                 int               *width,
                 int               *height )
{

  /* Variables. */


  /* Code. */

  /* Pich the correct icon. */
  switch( icon_type ) {

    case XTM_IC_ICON_ACL:
      *bits   = xtmAclIcon_bits;
      *width  = xtmAclIcon_width;
      *height = xtmAclIcon_height;
      break;

    case XTM_IC_ICON_ALARM_CLOCK1:
      *bits   = xtmAlarmClock1_bits;
      *width  = xtmAlarmClock1_width;
      *height = xtmAlarmClock1_height;
      break;

    case XTM_IC_ICON_ALARM_CLOCK2:
      *bits   = xtmAlarmClock2_bits;
      *width  = xtmAlarmClock2_width;
      *height = xtmAlarmClock2_height;
      break;

    case XTM_IC_ICON_ALARM_CLOCK3:
      *bits   = xtmAlarmClock3_bits;
      *width  = xtmAlarmClock3_width;
      *height = xtmAlarmClock3_height;
      break;

    case XTM_IC_ICON_ALARM_CLOCK4:
      *bits   = xtmAlarmClock4_bits;
      *width  = xtmAlarmClock4_width;
      *height = xtmAlarmClock4_height;
      break;

    case XTM_IC_ICON_ALARM_CLOCK5:
      *bits   = xtmAlarmClock5_bits;
      *width  = xtmAlarmClock5_width;
      *height = xtmAlarmClock5_height;
      break;

    case XTM_IC_ICON_ALARM_CLOCK5INV:
      *bits   = xtmAlarmClock5Inv_bits;
      *width  = xtmAlarmClock5Inv_width;
      *height = xtmAlarmClock5Inv_height;
      break;

    case XTM_IC_ICON_ALARM_CLOCK6:
      *bits   = xtmAlarmClock6_bits;
      *width  = xtmAlarmClock6_width;
      *height = xtmAlarmClock6_height;
      break;

    case XTM_IC_ICON_ALARM_CLOCK7:
      *bits   = xtmAlarmClock7_bits;
      *width  = xtmAlarmClock7_width;
      *height = xtmAlarmClock7_height;
      break;

    case XTM_IC_ICON_ALARM_CLOCK8:
      *bits   = xtmAlarmClock8_bits;
      *width  = xtmAlarmClock8_width;
      *height = xtmAlarmClock8_height;
      break;

    case XTM_IC_ICON_ALARM_CLOCK9:
      *bits   = xtmAlarmClock9_bits;
      *width  = xtmAlarmClock9_width;
      *height = xtmAlarmClock9_height;
      break;

    case XTM_IC_ICON_CALENDAR:
      *bits   = xtmCalendarIcon_bits;
      *width  = xtmCalendarIcon_width;
      *height = xtmCalendarIcon_height;
      break;

    case XTM_IC_ICON_CUSTOM:
      *bits   = xtmCustIcon_bits;
      *width  = xtmCustIcon_width;
      *height = xtmCustIcon_height;
      break;

    case XTM_IC_ICON_EDIT_ENTRY:
      *bits   = xtmAppEditIcon_bits;
      *width  = xtmAppEditIcon_width;
      *height = xtmAppEditIcon_height;
      break;

    case XTM_IC_ICON_MAIL:
      *bits   = xtmMailIcon_bits;
      *width  = xtmMailIcon_width;
      *height = xtmMailIcon_height;
      break;

    case XTM_IC_ICON_MESSAGE:
      *bits   = xtmMessageIcon_bits;
      *width  = xtmMessageIcon_width;
      *height = xtmMessageIcon_height;
      break;

    case XTM_IC_ICON_NAV_CAL:
      *bits   = xtmNavCalIcon_bits;
      *width  = xtmNavCalIcon_width;
      *height = xtmNavCalIcon_height;
      break;

    case XTM_IC_ICON_PRINT:
      *bits   = xtmPrintIcon_bits;
      *width  = xtmPrintIcon_width;
      *height = xtmPrintIcon_height;
      break;

    case XTM_IC_ICON_REMINDER:
      *bits   = xtmReminderIcon_bits;
      *width  = xtmReminderIcon_width;
      *height = xtmReminderIcon_height;
      break;

    case XTM_IC_ICON_SCHEDULE:
      *bits   = xtmScheduleIcon_bits;
      *width  = xtmScheduleIcon_width;
      *height = xtmScheduleIcon_height;
      break;

    case XTM_IC_ICON_SUMMARY:
      *bits   = xtmSummaryIcon_bits;
      *width  = xtmSummaryIcon_width;
      *height = xtmSummaryIcon_height;
      break;

    case XTM_IC_ICON_XDIARY_LOGO:
      *bits   = xtmXdiaryLogo_bits;
      *width  = xtmXdiaryLogo_width;
      *height = xtmXdiaryLogo_height;
      break;

    case XTM_IC_ICON_PLANNER:
      *bits   = xtmPlannerIcon_bits;
      *width  = xtmPlannerIcon_width;
      *height = xtmPlannerIcon_height;
      break;

    case XTM_IC_ICON_ANI_MOVE:
      *bits   = xtmMoveAnimate_bits;
      *width  = xtmMoveAnimate_width;
      *height = xtmMoveAnimate_height;
      break;

    case XTM_IC_ICON_ANI_MOVE1:
      *bits   = xtmMoveAnimate1_bits;
      *width  = xtmMoveAnimate1_width;
      *height = xtmMoveAnimate1_height;
      break;

    case XTM_IC_ICON_ANI_MOVE2:
      *bits   = xtmMoveAnimate2_bits;
      *width  = xtmMoveAnimate2_width;
      *height = xtmMoveAnimate2_height;
      break;

    case XTM_IC_ICON_ANI_MOVE3:
      *bits   = xtmMoveAnimate3_bits;
      *width  = xtmMoveAnimate3_width;
      *height = xtmMoveAnimate3_height;
      break;

    case XTM_IC_ICON_ANI_MOVE4:
      *bits   = xtmMoveAnimate4_bits;
      *width  = xtmMoveAnimate4_width;
      *height = xtmMoveAnimate4_height;
      break;

    case XTM_IC_ICON_ANI_MOVE5:
      *bits   = xtmMoveAnimate5_bits;
      *width  = xtmMoveAnimate5_width;
      *height = xtmMoveAnimate5_height;
      break;

    case XTM_IC_ICON_ANI_MOVE6:
      *bits   = xtmMoveAnimate6_bits;
      *width  = xtmMoveAnimate6_width;
      *height = xtmMoveAnimate6_height;
      break;

    case XTM_IC_ICON_CAL_TOP:
      *bits   = xtmCalTop_bits;
      *width  = xtmCalTop_width;
      *height = xtmCalTop_height;
      break;

    case XTM_IC_ICON_CAL_LEFT_TOP:
      *bits   = xtmCalLeftTop_bits;
      *width  = xtmCalLeftTop_width;
      *height = xtmCalLeftTop_height;
      break;

    case XTM_IC_ICON_CAL_RIGHT_TOP:
      *bits   = xtmCalRightTop_bits;
      *width  = xtmCalRightTop_width;
      *height = xtmCalRightTop_height;
      break;

    case XTM_IC_ICON_DROP_MENU:
      *bits   = xtmDropMenu_bits;
      *width  = xtmDropMenu_width;
      *height = xtmDropMenu_height;
      break;

    default:
      *bits   = xtmDefaultIcon_bits;
      *width  = xtmDefaultIcon_width;
      *height = xtmDefaultIcon_height;
      break;

  } /* switch */


  return;

} /* fetchIconInfo */
