/*----------------------------------------------------------------------------
--
--  Module:           xtmHelp
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Display help for XDiary.
--
--  Filename:         xtmHelp.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-07-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xtmHelp.c, Version: 1.1, Date: 95/02/18 15:52:24";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Intrinsic.h>

#include <Xm/Xm.h>

#include "System.h"
#include "Message.h"

#include "msgXdiary.h"
#include "xtmGlobal.h"
#include "xtmIcons.h"
#include "xitError.h"
#include "xitInfo.h"
#include "xitTools.h"
#include "xtmHelp.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Name of module. */
static char  *module_name = "xtmHelp";


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void 
  displayReleaseNotesCB( Widget         widget,
                         XIT_IN_HANDLE  info_handle,
                         XtPointer      call_data );


/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmHlDisplayHelp( XIT_IN_HANDLE  info_handle,
                    int            help_index,
                    char           *window_id,
                    char           *widget_id )
{

  /* Variables. */
  char  book[ 50 ];
  char  topic[ 50 ];

  static char  *help_types[] = {
    /* onContext */  "top",
    /* onWindow */   "top",
    /* onKeys */     "keyInfo",
    /* index */      "top",
    /* onHelp */     "help",
    /* onVersion */  "versionInfo",
  };


  /* Code. */

  strcpy( book, "Manual" );
  strcpy( topic, help_types[ help_index ] );


  /* Help for window? */
  if( help_index == 1 && *window_id != '\0' ) {
    sprintf( book,  "%s",    "Windows" );
    sprintf( topic, "win%s", window_id );
  }


  /* Display the information window. */
  xitInDisplayInfo( info_handle, book, topic );


  /* Table of contents? */
  if( help_index == XTM_HL_INDEX_INDEX )
    xitInDisplayToc( info_handle );


  return;

} /* xtmHlDisplayHelp */


/*----------------------------------------------------------------------*/

void
  xtmHlDisplayAboutWindow( Widget  parentW )
{

  /* Variables. */
  static Pixmap  logo_pixmap = XmUNSPECIFIED_PIXMAP;


  /* Code. */

  /* Create the Pixmap? */
  if( logo_pixmap == XmUNSPECIFIED_PIXMAP )
    logo_pixmap = xtmIcFetchSimplePixmap( parentW, 
                                          XTM_IC_ICON_XDIARY_LOGO, False );

  /* Create the About box. */
  (void) xitCreatePixmapDialog( 
           parentW, "AboutDialog", 
	   msgGetText( MXDI_ABOUT_TITLE ),
           msgGetText( MXDI_ABOUT_TEXT ),
           logo_pixmap,
           NULL, NULL );


  return;

} /* xtmHlDisplayAboutWindow */


/*----------------------------------------------------------------------*/

void
  xtmHlDisplayReleaseNotes( XIT_IN_HANDLE  info_handle,
                            Widget         parentW )
{

  /* Variables. */
  Arg       args[ 10 ];
  Cardinal  n;
  Widget    logoLa;
  Widget    relTl;
  Widget    relTextLa;
  Widget    tempW;
  Widget    workFo;

  static Pixmap  logo_pixmap = XmUNSPECIFIED_PIXMAP;

  static XIT_ACTION_AREA_ITEM  action_buttons[] = {
    { "",   displayReleaseNotesCB, NULL },
    { NULL, NULL,                  NULL },
    { "",   NULL,                  NULL },
  };


  /* Code. */

  if( info_handle == NULL )
    return;

  /* Create the window (a toplevel window). */
  action_buttons[ 0 ].label = msgGetText( MXDI_OK_BUTTON );
  action_buttons[ 0 ].data  = info_handle;
  action_buttons[ 2 ].label = msgGetText( MXDI_CANCEL_BUTTON );
  action_buttons[ 2 ].data  = info_handle;


  /* Create a separate window. */
  tempW = xitGetToplevelWidget( parentW );

  relTl = xitCreateToplevelDialog( tempW, "RelTl", 
                                   1, 0,
                                   action_buttons, 
                                   XtNumber( action_buttons ) );

  n = 0;
  XtSetArg( args[ n ], XmNtitle, msgGetText( MXDI_RELEASE_NOTES_TITLE ) ); n++;
  XtSetValues( relTl, args, n );

  /* Reference to the contents of the window. */
  workFo = XtNameToWidget( relTl, "RelTlBase.RelTlFo" );


  /* Create the Pixmap? */
  if( logo_pixmap == XmUNSPECIFIED_PIXMAP )
    logo_pixmap = xtmIcFetchSimplePixmap( workFo, 
                                          XTM_IC_ICON_XDIARY_LOGO, False );


  /* Logo label. */
  logoLa = xitCreateLabel( workFo, "LogoLa", " ", -1 );

  n = 0;
  XtSetArg( args[ n ], XmNlabelType, XmPIXMAP ); n++;
  XtSetArg( args[ n ], XmNlabelPixmap, logo_pixmap ); n++;
  XtSetValues( logoLa, args, n );


  /* Release notes question. */
  relTextLa = xitCreateLabel( workFo, "RelTextLa",
                              msgGetText( MXDI_DISPLAY_RELEASE_NOTES ), -1 );


  /* Put the elements together. */
  xitAttachWidget( logoLa,
                   XmATTACH_FORM, NULL, XmATTACH_FORM, NULL,
                   XmATTACH_NONE, NULL, XmATTACH_NONE, NULL );
  xitAttachWidget( relTextLa,
                   XmATTACH_FORM, NULL, XmATTACH_WIDGET, logoLa,
                   XmATTACH_NONE, NULL, XmATTACH_NONE,   NULL );

  /* Make sure there is enough space between the children. */
  n = 0;
  XtSetArg( args[ n ], XmNtopOffset,    5 ); n++;
  XtSetArg( args[ n ], XmNleftOffset,   5 ); n++;
  XtSetArg( args[ n ], XmNrightOffset,  5 ); n++;
  XtSetArg( args[ n ], XmNbottomOffset, 5 ); n++;
  XtSetValues( logoLa,    args, n );
  XtSetValues( relTextLa, args, n );


  /* Manage the widgets. */
  XtManageChild( logoLa );
  XtManageChild( relTextLa );

  /* Position in the middle of the screen. */
  {
    char       geometry[ 50 ];
    Dimension  form_height;
    Dimension  form_width;
    Position   x;
    Position   y;

    n = 0;
    XtSetArg( args[ n ], XmNwidth,  &form_width ); n++;
    XtSetArg( args[ n ], XmNheight, &form_height ); n++;
    XtGetValues( relTextLa, args, n );

    x = (WidthOfScreen(  XtScreen( parentW ) ) - form_width)  / 2;
    y = (HeightOfScreen( XtScreen( parentW ) ) - form_height) / 3;

    sprintf( geometry, "+%d+%d", x, y );

    n = 0;
    XtSetArg( args[ n ], XmNgeometry, geometry ); n++;
    XtSetValues( relTl, args, n );
  }

  /* Set the size of the window. */
  xitSetSizeToplevelDialog( relTl, True );


  XtPopup( relTl, XtGrabNone );


  return;

} /* xtmHlDisplayReleaseNotes */


/*----------------------------------------------------------------------*/

static void 
  displayReleaseNotesCB( Widget         widget,
                         XIT_IN_HANDLE  info_handle,
                         XtPointer      call_data )
{

  /* Variables. */
  char  book[ 50 ];
  char  topic[ 50 ];


  /* Code. */

  sprintf( book,  "News" );
  sprintf( topic, "ver%s", SYS_VERSION_ID );


  /* Display the information window. */
  xitInDisplayInfo( info_handle, book, topic );

  XtDestroyWidget( XtParent( XtParent( widget ) ) );


  return;

} /* displayReleaseNotesCB */


