/*----------------------------------------------------------------------------
--
--  Module:           xtmEditPref
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmEditPref.c.
--
--  Filename:         xtmEditPref.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmEditPref.h, Version: 1.1, Date: 95/02/18 15:52:16 */


/* Only include this module once. */
#ifndef define_xtmEditPref_h
#  define define_xtmEditPref_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Values passed to the preference window. */
typedef struct {
  int                     alarm_lines;
  int                     bg_color_index;
  int                     day_list_lines;
  int                     fg_color_index;
  UINT32                  flags;
  XTM_DB_ALL_ENTRY_TYPES  entry_type;
} XTM_EP_SET_PREF_DATA;

/* Result values passed from the preference window. */
typedef struct {
  int     alarm_lines;
  int     bg_color_index;
  int     day_list_lines;
  int     fg_color_index;
  UINT32  flags;
} XTM_EP_GET_PREF_DATA;


/* Reasons when the action routine is called. */
typedef enum {
  XTM_EP_REASON_CANCEL,
  XTM_EP_REASON_DESTROY,
  XTM_EP_REASON_OK
} XTM_EP_REASON;

/* Callback when the alarm window is destroyed. */
typedef void ( *XTM_EP_ACTION_CB ) ( XTM_EP_REASON, 
                                     void *, XTM_EP_GET_PREF_DATA * );

/* Handle to use when comminucating with the window. */
typedef  void  *XTM_EP_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmEpDestroy( XTM_EP_HANDLE  pref_handle );

void
  xtmEpEditPreferences( XTM_EP_HANDLE         pref_handle,
                        XTM_EP_SET_PREF_DATA  *values_ref );

XTM_EP_HANDLE
  xtmEpInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   XTM_EP_ACTION_CB      actionCB,
                   void                  *user_data );

#endif

