/*----------------------------------------------------------------------------
--
--  Module:           xtmEditEntry
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmEditEntry.c.
--
--  Filename:         xtmEditEntry.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1990-12-18
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmEditEntry.h, Version: 1.1, Date: 95/02/18 15:52:16 */


/* Only include this module once. */
#ifndef define_xtmEditEntry_h
#  define define_xtmEditEntry_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Flags to use with xtmEdSetValues. */
#define XTM_ED_SET_DATE      (1<<0)
#define XTM_ED_SET_TIME      (1<<1)
#define XTM_ED_SET_DURATION  (1<<2)
#define XTM_ED_SET_TEXT      (1<<3)
#define XTM_ED_SET_IS_NOTE   (1<<4)
#define XTM_ED_SET_IS_APP    (1<<5)


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_ED_REASON_DESTROY,
  XTM_ED_REASON_UPDATE
} XTM_ED_REASON;

/* Callback when the editor window is destroyed. */
typedef void ( *XTM_ED_ACTION_CB ) ( XTM_ED_REASON, void * );

/* Handle to use when comminucating with the editor. */
typedef  void  *XTM_ED_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmEdDestroy( XTM_ED_HANDLE  editor_handle );

void
  xtmEdEmptyCache();

XTM_ED_HANDLE
  xtmEdInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   int                   default_duration,
                   int                   earliest_hour,
                   int                   latest_hour,
                   int                   min_delta,
                   XTM_ED_ACTION_CB      actionCB,
                   void                  *user_data );

void
  xtmEdEditEntry( XTM_ED_HANDLE  editor_handle,
                  char           *db_name,
                  UINT32         entry_id,
                  TIM_TIME_REF   use_date,
                  TIM_TIME_REF   use_time );

void
  xtmEdSetValues( XTM_ED_HANDLE  editor_handle,
                  UINT32         flags,
                  TIM_TIME_REF   use_date,
                  TIM_TIME_REF   use_time,
                  UINT32         duration,
                  char           *text );

#endif

