/*----------------------------------------------------------------------------
--
--  Module:           xitSetFocus
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Set traverse focus to the given widget when it's realized
--    (focus is only set once).
--
--  Filename:         xitSetFocus.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-02-25
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitSetFocus.c, Version: 1.1, Date: 95/02/18 15:10:47";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void
  focusToCB( XtPointer     data, 
             XtIntervalId  *timer_id );

static void
  setFocusCB( Widget     widget,
              XtPointer  client_data,
              XtPointer  call_data );


/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void 
  xitSetFocus( Widget  widget,
               Widget  focus_toW )
{

  /* Code. */

  /* Do it with the focus callback. */
#ifndef XD_HAS_FOCUS_BUG
  XtAddCallback( widget, XmNfocusCallback,
                 (XtCallbackProc) setFocusCB, (XtPointer) focus_toW );
#endif


  return;

} /* xitSetFocus */


/*----------------------------------------------------------------------*/

void 
  xitGrabFocus( Widget  focus_toW )
{

  /* Code. */

  /* Grab focus for a REALIZED widget. */
  XmProcessTraversal( focus_toW, XmTRAVERSE_CURRENT );
  XmProcessTraversal( focus_toW, XmTRAVERSE_CURRENT );


  return;

} /* xitSetFocus */


/*----------------------------------------------------------------------*/

static void
  setFocusCB( Widget     widget,
              XtPointer  client_data,
              XtPointer  call_data )
{

  /* Code. */

  /* We don't need the focus callback anymore. */
  XtRemoveCallback( widget, XmNfocusCallback, 
                    (XtCallbackProc) setFocusCB, (XtPointer) client_data );

  /* Play it safe, let X do the job. */
  XtAppAddTimeOut( XtWidgetToApplicationContext( widget ), 
                   0,
                   (XtTimerCallbackProc) focusToCB, (XtPointer) client_data );

  return;

} /* setFocusCB */


/*----------------------------------------------------------------------*/

static void
  focusToCB( XtPointer     data, 
             XtIntervalId  *timer_id )
{

  /* Code. */

  XmProcessTraversal( (Widget) data, XmTRAVERSE_CURRENT );


  return;

} /* focusToCB */



