/*----------------------------------------------------------------------------
--
--  Module:           XitRwPixButton
--
--  Project:          XitRw - Roger's Widget set.
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This is the private header file for the widget.
--    A PixB button can display both a text and a pixmap.
--
--  Filename:         xitRwPixBP.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-17
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitRwPixBP.h, Version: 1.1, Date: 95/02/18 15:10:46 */


/* Only include once. */
#ifndef define_xitRwPixBP_h
#  define define_xitRwPixBP_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

/* Superclass is XmPrimitive. Its header file is XmP.h. */

#include <Xm/XmP.h>

#include "System.h"

/* Public header file for this widget. */
#include "xitRwPixB.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* CLASS RECORD */

/* New fields for the pixel button widget class record. */

typedef struct {

  XtPointer  extension;

} XitRwPixButtonClassPart;


/* Full class record declaration. */

typedef struct {

  CoreClassPart            core_class;
  XmPrimitiveClassPart     primitive_class;
  XitRwPixButtonClassPart  pixbut_class;

} XitRwPixButtonClassRec;


/* INSTANCE RECORD */

typedef struct {

  /* RESOURCES. */

  /* Margins. */
  int              top_margin;
  int              left_margin;
  int              right_margin;
  int              bottom_margin;
  int              margin_height;
  int              margin_width;
  int              spacing;

  /* Graphical attributes. */
  unsigned char    shadow_type;
  int              pixmap_position;
  unsigned char    alignment;
  unsigned char    opposite_alignment;

  /* Font. */
  XmFontList       font_list;

  /* Things to display. */
  Pixmap           pixmap;
  XmString         label;

  /* Size recompute. */
  Boolean          recompute_size;

  /* Callbacks. */
  XtCallbackList   activate_callback;
  XtCallbackList   arm_callback;
  XtCallbackList   disarm_callback;

  /* PRIVATE STATE. */
  GC               gc;
  GC               clear_gc;
  GC               select_gc;
  GC               select_clear_gc;
  GC               insensitive_gc;

  Pixmap           insensitive_pixmap;

  int              pixmap_width;
  int              pixmap_height;
  int              string_width;
  int              string_height;

  int              x_pixmap;
  int              y_pixmap;
  int              x_string;
  int              y_string;

  Boolean          user_set_width;
  Boolean          user_set_height;

  Boolean          armed;

} XitRwPixButtonPart;


/* Full instance record declaration. */

typedef struct _XitRwPixButtonRec {

  CorePart            core;
  XmPrimitivePart     primitive;
  XitRwPixButtonPart  pixBut;

} XitRwPixButtonRec;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Conventional declaration. */
extern XitRwPixButtonClassRec xitRwPixButtonClassRec;


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

#endif
