/*----------------------------------------------------------------------------
--
--  Module:           xitInfoToc
--
--  Project:          xit - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file to module xitInfoToc.
--
--  Filename:         xitInfoToc.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-17
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitInfoToc.h, Version: 1.1, Date: 95/02/18 15:10:40 */


/* Only include this module once. */
#ifndef define_xitInfoToc_h
#  define define_xitInfoToc_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XIT_IT_REASON_DESTROY,
  XIT_IT_REASON_NEW_SECTION,
  XIT_IT_REASON_POPDOWN
} XIT_IT_REASON;


/* Callback function. */
typedef void  ( *XIT_IT_ACTION_CB ) ( XIT_IT_REASON, void *, char *, char * );

/* Handle to the toc window. */
typedef void  *XIT_IT_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xitItDestroy( XIT_IT_HANDLE  toc_handle );

void 
  xitItDisplayToc( XIT_IT_HANDLE  toc_handle,
                   char           *book_file );

XIT_IT_HANDLE
  xitItInitialize( Widget            parent,
                   XIT_IT_ACTION_CB  actionCB,
                   void              *user_data );


#endif
