/*----------------------------------------------------------------------------
--
--  Module:           xitIconWin
--
--  Project:          Xtools
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Put a pixmap in an icon window. Iconify a toplevel window.
--
--  Filename:         xitIconWin.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-12-11
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitIconWin.c, Version: 1.1, Date: 95/02/18 15:10:34";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>

#include "Standard.h"

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xitIconify( Widget  widget )
{

  /* Variables. */
  Atom                 xa_WM_CHANGE_STATE;
  Display              *display;
  Window               window;
  XClientMessageEvent  event;


  /* Code. */

  display = XtDisplay( widget );
  window  = XtWindow(  widget );

  xa_WM_CHANGE_STATE = XInternAtom( display, "WM_CHANGE_STATE", False );

  event.type         = ClientMessage;
  event.display      = display;
  event.message_type = xa_WM_CHANGE_STATE;
  event.format       = 32;
  event.data.l[ 0 ]  = IconicState;
  event.window       = window;

  XSendEvent( display, RootWindow( display, DefaultScreen( display ) ),
              True,
              (SubstructureRedirectMask | SubstructureNotifyMask),
              (XEvent *) &event );

  XFlush( display );


  return;

} /* xitIconify */


/*----------------------------------------------------------------------*/

void
  xitSetIconWindow( Widget           shell,
                    XIT_ICON_WINDOW  *icon_win,
                    Window           *window,
                    GC               *gc )
{

  /* Variables. */
  UINT32     border_width;
  UINT32     depth;
  UINT32     height;
  UINT32     width;
  INT32      x;
  INT32      y;
  Arg        args[ 10 ];
  Cardinal   n;
  Display    *display = XtDisplay( shell );
  Screen     *screen = XtScreen( shell );
  Window     root;
  XGCValues  gc_values;



  /* Code. */

  /* Size of pixmap to use. */
  XGetGeometry( display, icon_win -> image,
                &root, &x, &y, &width, &height, 
                &border_width, &depth );


  /* Fetch the icon window (if it exists). */
  n = 0;
  XtSetArg( args[ n ], XmNiconWindow, window ); n++;
  XtGetValues( shell, args, n );

  /* If there is no icon window, create one. */
  if( ! *window ) {

    UINT32                value_mask;
    XSetWindowAttributes  wa;

    wa.background_pixel  = icon_win -> icon_bg;
    wa.border_pixel      = icon_win -> icon_fg;
    wa.override_redirect = True;
    wa.event_mask        = ExposureMask;

    if( icon_win -> report_expose_events )
      value_mask = CWBackPixel|CWBorderPixel|CWOverrideRedirect|CWEventMask;
    else
      value_mask = CWBackPixel|CWBorderPixel|CWOverrideRedirect;

    *window = XCreateWindow( display, root, 
                             0, 0, width, height, 1, depth, InputOutput,
                             CopyFromParent, value_mask, &wa );

    /* If the window could not be created, try to set the pixmap as is. */
    if( ! *window ) {
      n = 0;
      XtSetArg( args[ n ], XmNiconPixmap, icon_win -> image ); n++;
      XtSetValues( shell, args, n );

      return;
    }

    /* Now when the window is created, set it. */
    n = 0;
    XtSetArg( args[ n ], XmNiconWindow, *window ); n++;
    XtSetValues( shell, args, n );

  } /* if */


  /* Create a GC to use? */
  if( *gc == NULL ) {

    gc_values.font = XLoadFont( display, "fixed" );

    *gc = XCreateGC( display, *window, GCFont, &gc_values );
  }


  /* Set the window's background pixmap to the image. */
  XSetWindowBackgroundPixmap( display, *window, icon_win -> image );
  XClearWindow( display, *window );


  /* Set the label in the icon? */
  if( icon_win -> label != NULL ) {

    Dimension  str_height;
    Dimension  str_width;

    /* Background and foreground colors. */
    gc_values.foreground = icon_win -> label_fg;
    gc_values.background = icon_win -> icon_bg;

    XChangeGC( display, *gc, (GCForeground|GCBackground), &gc_values );


    XmStringExtent( icon_win -> font_list, icon_win -> label, 
                     &str_width, &str_height );

    x = width  / 2 - (int) str_width  / 2 + icon_win -> x_offset;
    y = height / 2 - (int) str_height / 2 + icon_win -> y_offset;

    XmStringDrawImage( display, *window, 
                       icon_win -> font_list, icon_win -> label, *gc,
                       (Position) x, (Position) y + 4, str_width,
                       XmALIGNMENT_CENTER, XmSTRING_DIRECTION_L_TO_R,
                       NULL );

  } /* if */


  return;

} /* xitSetIconWindow */
