/*----------------------------------------------------------------------------
--
--  Module:           xitCrePush
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Creates a push button widget.
--
--  Filename:         xitCrePush.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitCrePush.c, Version: 1.1, Date: 95/02/18 15:10:25";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/PushB.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreatePushButton( Widget           parent, 
                       XIT_PUSH_STRUCT  *pb )
{

  /* Variables. */
  Arg        args[ 5 ];
  Cardinal   n;
  Widget     w;
  XmString   xstr = NULL;


  /* Code. */

  n = 0;
  if( pb -> title != NULL && strlen( pb -> title ) > 0 ) {
    xstr = XmStringCreateLtoR( pb -> title, CS );
    XtSetArg( args[ n ], XmNlabelString, xstr ); n++;
  }

  XtSetArg( args[ n ], XmNalignment, XmALIGNMENT_CENTER ); n++;

  if( pb -> mnemonic != NULL && strlen( pb -> mnemonic ) > 0 ) {
    XtSetArg( args[ n ], XmNmnemonic,  *pb -> mnemonic ); n++;
  }

  if( ! pb -> sensitive ) {
    XtSetArg( args[ n ], XmNsensitive, False ); n++;
  } else {
    XtSetArg( args[ n ], XmNsensitive, True ); n++;
  }

  w = XmCreatePushButton( parent, pb -> name, args, n );

  if( pb -> callback != NULL ) 
    XtAddCallback( w, XmNactivateCallback, pb -> callback, pb -> name );

  if( xstr != NULL )
    XmStringFree( xstr );

  return( w );

} /* xitCreatePushButton */
