/*----------------------------------------------------------------------------
--
--  Module:           xitColor
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Color handling routines.
--
--  Filename:         xitColor.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-03-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitColor.c, Version: 1.1, Date: 95/02/18 15:10:21";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

#include <X11/Intrinsic.h>

#include <Xm/Xm.h>

#include "System.h"

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Boolean
  xitAllocNamedColor( Widget  widget,
                      char    *color_string,
                      Pixel   *color )
{

  /* Variables. */
  Status  ok;
  XColor  alloc_color;


  /* Code. */

  ok = XParseColor( XtDisplay( widget ),
                    DefaultColormapOfScreen( XtScreen( widget ) ),
                    color_string,
                    &alloc_color );
  if( ! ok )
    return( False );


  ok = XAllocColor( XtDisplay( widget ),
                    DefaultColormapOfScreen( XtScreen( widget ) ),
                    &alloc_color );
  if( ! ok )
    return( False );


  *color = (Pixel) alloc_color.pixel;


  return( True );

} /* xitAllocNamedColor */


