/*----------------------------------------------------------------------------
--
--  Module:           XmUbArrowLabel
--
--  Project:          XmUb - Ulle's Motif widgets
--  System:           
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This is the private header file for the widget.
--
--  Filename:         XmUbArrLabP.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-09-28
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: XmUbArrLabP.h, Version: 1.1, Date: 95/02/18 15:10:07 */

#ifndef _XmUbArrLabP_h
#define _XmUbArrLabP_h

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <X11/StringDefs.h>
#include <Xm/XmP.h>

#if XmVersion > 1001
#include "Xm/ManagerP.h"
#endif

#include "XmUbArrLab.h"

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Indices for widgets in the internal children array. */

#define NO_INTERNAL_CHILDREN  ( XmUbAL_LAST_CHILD + 1 )

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Arrow placement type. */
typedef unsigned char  arrowPlacement;


/* CLASS RECORD */

typedef struct {

  XtPointer  extension;

} XmUbArrowLabelClassPart;


/* Full class record declaration. */

typedef struct {

  CoreClassPart            core_class;
  CompositeClassPart       composite_class;
  ConstraintClassPart      constraint_class;
  XmManagerClassPart       manager_class;
  XmUbArrowLabelClassPart  arrow_label_class;

} XmUbArrowLabelClassRec;


/* INSTANCE RECORD */

typedef struct {

  /* RESOURCES. */
  /* Callbacks. */
  XtCallbackList    activate_callback;

  /* Label resources. */
  XmString          label_string;

  /* Offsets and spacings. */
  Dimension         margin_height;
  Dimension         margin_width;
  Dimension         spacing;

  /* Size computation. */
  Boolean           recompute_width;
  Boolean           recompute_height;

  /* Internal widget creation. */
  unsigned char     arrow_orientation;
  arrowPlacement    arrow_placement;

  /* PRIVATE STATE. */
  /* Internal widgets. Some may be NULL depending on format. */
  Widget    internal_children[ NO_INTERNAL_CHILDREN ];
  
  Boolean   resize_called;  /* Because unclear widget set philosophy. */
  Boolean   internal_widgets_created;

} XmUbArrowLabelPart;

/* Full instance record declaration. */

typedef struct _XmUbArrowLabelRec {

  CorePart            core;
  CompositePart       composite;
  ConstraintPart      constraint;
  XmManagerPart       manager;
  XmUbArrowLabelPart  al;

} XmUbArrowLabelRec;



/* Constraint record for the children of this widget. */
typedef struct {

  XtPointer  extension;

} XmUbArrowLabelConstraintsPart;


typedef struct {

  XmManagerConstraintPart        manager;
  XmUbArrowLabelConstraintsPart  al;

} XmUbArrowLabelConstraintsRec, *XmUbArrowLabelConstraints;

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Conventional declaration. */
extern XmUbArrowLabelClassRec xmUbArrowLabelClassRec;

/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

#endif
