/*----------------------------------------------------------------------------
--
--  Module:           XmUbArrowLabel
--
--  Project:          XmUb - Ulle's Motif widgets
--  System:           
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This is the public header file for the widget.
--
--    The arrow label widget displays one label and two arrow buttons.
--    It may be used for stepping, like in <-Month->.
--
--  Filename:         XmUbArrLab.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-09-28
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: XmUbArrLab.h, Version: 1.1, Date: 95/02/18 15:10:06 */

#ifndef _XmUbArrLab_h
#define _XmUbArrLab_h

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <time.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>

/*----------------------------------------------------------------------------
--  Resources for the arrow label widget.
--  All XmManager resources apply. 
--  The following list describes resources added in this widget.
--
--  XmNactivateCallback        CSG
--      XmCCallback
--    Callback(s) that is called when an arrow button was activated.
--    Callback reason: XmUbCR_BACK_ARROW_ACTIVATED or
--                     XmUbCR_FORWARD_ARROW_ACTIVATED.
--    Type:    XtCallbackList
--    Default: NULL
--                        
--  XmUbNalArrowOrientation    CG
--      XmCOrientation
--    The orientation of the arrows. Valid values are XmHORIZONTAL and 
--    XmVERTICAL.
--    When the orientation is horizontal, the back arrow will be a left arrow 
--    and the forward arrow will point to the right.
--    When the orientation is vertical, the back arrow points up and the 
--    forward arrow points down.
--    Type:    unsigned char
--    Default: XmHORIZONTAL
--
--  XmUbNalArrowPlacement      CG
--      XmUbCAlArrowPlacement
--    The placement of the arrows. Valid values are
--      XmUbARROWS_LEFT        Arrows together on the left, label on the right.
--      XmUbARROWS_RIGHT       Arrows together on the right, label on the left.
--      XmUbARROWS_SPREAD_OUT  Label in the middle, arrows on both sides.
--                        
--    The back arrow is always placed left of the forward arrow.
--    Type:    unsigned char
--    Default: XmUbARROWS_SPREAD_OUT
--
--  XmNlabelString             CSG
--      XmCXmString
--    The string to be shown in the label. If none is given, it will be the 
--    name of the label widget. The string is copied internally. A copy will
--    be returned by XtGetValues.
--    Type:    XmString
--    Default: NULL
--
--  XmNmarginHeight            CSG
--      XmCMarginHeight       
--    The margin used at the top and the bottom of the widget.
--    Type:    Dimension
--    Default: 0
--                        
--  XmNmarginWidth             CSG
--      XmCMarginWidth
--    The margin used at the left and right ends of the widget.
--    Type:    Dimension
--    Default: 0
--                        
--  XmNspacing                 CSG
--      XmCSpacing
--    The space between the different components.
--    Type:    Dimension
--    Default: 2
--
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

#define XmUbNalArrowOrientation   "alArrowOrientation"
#define XmUbNalArrowPlacement     "alArrowPlacement"
#define XmUbNalRecomputeHeight    "alRecomputeHeight"
#define XmUbNalRecomputeWidth     "alRecomputeWidth"

#define XmUbCAlArrowPlacement     "AlArrowPlacement"
#define XmUbCAlRecomputeHeight    "AlRecomputeHeight"
#define XmUbCAlRecomputeWidth     "AlRecomputeWidth"

/* Arrow placement. */
#define XmUbARROWS_LEFT        0
#define XmUbARROWS_RIGHT       1
#define XmUbARROWS_SPREAD_OUT  2


/* Id's for children retrieval. */
#define XmUbAL_CHILD_LABEL          0
#define XmUbAL_CHILD_BACK_ARROW     1
#define XmUbAL_CHILD_FORWARD_ARROW  2

#define XmUbAL_FIRST_CHILD  XmUbAL_CHILD_LABEL
#define XmUbAL_LAST_CHILD   XmUbAL_CHILD_FORWARD_ARROW

/* Callback reasons. */
#define XmUbCR_BACK_ARROW_ACTIVATED      0
#define XmUbCR_FORWARD_ARROW_ACTIVATED   1

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Callback structure. */

typedef struct {

  int      reason;
  XEvent   *event;
  Widget   child;

} XmUbArrowLabelCallbackStruct;


/* 
-- CALLBACKS
--
-- XmNactivateCallback
--   Called when an arrow button is pressed.
--   
--   reason              XmUbCR_BACK_ARROW_ACTIVATED or
--                       XmUbCR_FORWARD_ARROW_ACTIVATED.
--   event               The button press callback event.
--   child               The widget id for the button that was pressed.
--
*/



/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Class record constants. */
extern WidgetClass xmUbArrowLabelWidgetClass;


typedef struct _XmUbArrowLabelClassRec *XmUbArrowLabelWidgetClass;
typedef struct _XmUbArrowLabelRec      *XmUbArrowLabelWidget;


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

Widget  
  XmUbCreateArrowLabel( Widget    parent,
                        String    name,
                        ArgList   arglist,
                        Cardinal  argcount );

Widget 
  XmUbArrowLabelGetChild( Widget  widget,
                          int     child );


#endif


