/*----------------------------------------------------------------------------
--
--  Module:           xtmUpdate
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmUpdate.
--
--  Filename:         xtmUpdate.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-04-03
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmUpdate.h, Version: 1.1, Date: 95/02/18 15:52:55 */


/* Include this file only once. */
#ifndef define_xtmUpdate_h
#  define define_xtmUpdate_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Action flags. */
#define  XTM_UP_MINUTE_TICK           (1<<0)
#define  XTM_UP_CALENDAR              (1<<1)
#define  XTM_UP_NAV_CALENDAR          (1<<2)
#define  XTM_UP_SCHEDULE              (1<<3)
#define  XTM_UP_REFRESH_TICK          (1<<4)
#define  XTM_UP_NEW_DAY               (1<<5)
#define  XTM_UP_PLANNER               (1<<6)


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Callback when calling a registered callback. */
typedef void ( *XTM_UP_UPDATE_CB ) ( UINT32, void *, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmUpDoUpdate( UINT32  flags,
                 void    *update_user_data );

void
  xtmUpInitialize( XtAppContext  context,
                   int           refresh_delta );

UINT32
  xtmUpRegister( UINT32            flags,
                 XTM_UP_UPDATE_CB  updateCB,
                 void              *user_data );

void
  xtmUpRemove( UINT32  id );


#endif
