/*----------------------------------------------------------------------------
--
--  Module:           xtmTags
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmTags.c.
--
--  Filename:         xtmTags.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-03-05
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmTags.h, Version: 1.1, Date: 95/02/18 15:52:53 */


/* Only include this module once. */
#ifndef define_xtmTags_h
#  define define_xtmTags_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Handle to use when comminucating with the tags DB. */
typedef  void  *XTM_TG_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

XTM_TG_HANDLE
  xtmTgBuildTagDb( Widget  parentW,
                   char    *tags_ref );

Boolean
  xtmTgFetchTagColor( XTM_TG_HANDLE  tag_handle,
                      char           *search_tag,
                      Pixel          *fg_color,
                      Pixel          *bg_color );

void
  xtmTgFreeTagDb( XTM_TG_HANDLE  tag_handle );

#endif
