/*----------------------------------------------------------------------------
--
--  Module:           xtmSchedMain
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmSchedMain.c.
--
--  Filename:         xtmSchedMain.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-04-04
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmSchedMain.h, Version: 1.1, Date: 95/02/18 15:52:45 */


/* Only include this module once. */
#ifndef define_xtmSchedMain_h
#  define define_xtmSchedMain_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "TimDate.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Internal schedule flags. */
#define XTM_SM_USE_GRID        (1<<0)
#define XTM_SM_CONFIRM         (1<<1)
#define XTM_SM_LIST_LAYOUT     (1<<2)
#define XTM_SM_ALL_STANDING    (1<<3)
#define XTM_SM_AUTO_NAV_CAL    (1<<4)
#define XTM_SM_ENTRY_HANDLES   (1<<5)
#define XTM_SM_ENTRY_FLAGS     (1<<6)
#define XTM_SM_READ_ONLY       (1<<7)
#define XTM_SM_ONLY_ONE        (1<<8)
#define XTM_SM_TRUE_COLOR_INC  (1<<9)


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_SM_REASON_DESTROY,
  XTM_SM_REASON_EXIT
} XTM_SM_REASON;

/* Parameter for initialization. */
typedef struct {
  TIM_TIME_REF  entry_start;
  TIM_TIME_REF  entry_stop;
  int           entry_delta;
  UINT32        default_flags;
} XTM_SM_INIT_REC, *XTM_SM_INIT_REF;

/* Handle to use when comminucating with the schedule window. */
typedef  void  *XTM_SM_HANDLE;

/* Callback when the calendar window is cahnged. */
typedef void ( *XTM_SM_ACTION_CB ) ( XTM_SM_REASON, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmSmDestroy( XTM_SM_HANDLE  sched_handle );

void
  xtmSmEmptyCache();

XTM_SM_HANDLE
  xtmSmInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                toplevel,
                   char                  *db_name,
                   XTM_SM_INIT_REF       init_ref,
                   XTM_SM_ACTION_CB      actionCB,
                   void                  *user_data );

void
  xtmSmSetFlags( XTM_SM_HANDLE  sched_handle,
                 UINT32         flags );

Boolean
  xtmSmViewLastUsed( TIM_TIME_REF   start_date );

void
  xtmSmViewSchedule( XTM_SM_HANDLE  sched_handle,
                     TIM_TIME_REF   start_date,
                     Boolean        iconic );

#endif
