/*----------------------------------------------------------------------------
--
--  Module:           xtmReminder
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmReminder
--
--  Filename:         xtmReminder.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-02-16
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmReminder.h, Version: 1.1, Date: 95/02/18 15:52:41 */


/* Include this module only once. */
#ifndef define_xtmReminder_h
#  define define_xtmReminder_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "TimDate.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Max length of the alarm text. */
#define  XTM_RD_MAX_ALARM_TEXT    300

/* Max number of alarms we can have. */
#define  XTM_RD_MAX_ALARMS        5


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reference to reminder record. */
typedef struct xtm_rd_reminder  *XTM_RD_REMINDER_REF;


/* Callback when Close Window is selected. */
typedef void ( *XTM_RD_CLOSE_CB ) (Widget, void *, void * );


/* Callback when Help Button is selected. */
typedef void ( *XTM_RD_HELP_CB ) (Widget, void *, int );


/* Definitions for one single alarm. */
typedef struct {
  Boolean       active;
  TIM_TIME_REF  alarm_time;
  char          text[ XTM_RD_MAX_ALARM_TEXT + 1 ];
} XTM_RD_ALARM_INFO;


/* Data for the reminder. */
typedef struct xtm_rd_reminder {
  Boolean            sliderCB_active;
  int                curr_work_alarm;
  char               empty_time;
  void               *user_data;
  Widget             reminderW;
  Widget             toplevel;
  XtAppContext       context;
  XTM_RD_ALARM_INFO  alarm[ XTM_RD_MAX_ALARMS ];
  XTM_RD_CLOSE_CB    closeCB;
  XTM_RD_HELP_CB     helpCB;
} XTM_RD_REMINDER;



/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmRdDestroyReminder( XTM_RD_REMINDER_REF  reminder_ref );

void 
  xtmRdDisplayReminder( XTM_RD_REMINDER_REF  reminder_ref );

void
  xtmRdHideReminder( XTM_RD_REMINDER_REF  reminder_ref );

XTM_RD_REMINDER_REF
  xtmRdInitializeReminder( Widget           parent,
                           XtAppContext     context,
                           XTM_RD_CLOSE_CB  closeCB,
                           XTM_RD_HELP_CB   helpCB,
                           void             *user_data );
Widget
  xtmRdToplevelWindow( XTM_RD_REMINDER_REF  reminder_ref );

#endif
