/*----------------------------------------------------------------------------
--
--  Module:           xtmPrEntries
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmPrEntries.c.
--
--  Filename:         xtmPrEntries.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1990-01-05
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmPrEntries.h, Version: 1.1, Date: 95/02/18 15:52:40 */


/* Only include this module once. */
#ifndef define_xtmPrintEntries_h
#  define define_xtmPrintEntries_h



/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>

#include "xtmGlobal.h"
#include "xtmDbFilter.h"
#include "TimDate.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_PR_REASON_DESTROY
} XTM_PR_REASON;

/* Handle to use when comminucating with the printer window. */
typedef  void  *XTM_PR_HANDLE;

/* Callback when the printerwindow is destroyed. */
typedef void ( *XTM_PR_ACTION_CB ) ( XTM_PR_REASON, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmPrDestroy( XTM_PR_HANDLE  printer_handle );

void 
  xtmPrDisplayPrinter( XTM_PR_HANDLE      printer_handle,
                       TIM_TIME_REF       from_date,
                       TIM_TIME_REF       to_date,
                       int                display_lines,
                       XTM_DM_FILTER_REC  *filter_ref );

void
  xtmPrEmptyCache();

XTM_PR_HANDLE
  xtmPrInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                toplevel,
                   char                  *db_name,
                   XTM_PR_ACTION_CB      actionCB,
                   void                  *user_data );

void
  xtmPrSetCalendar( XTM_PR_HANDLE  printer_handle,
                    char           *cal_name );

#endif

