/*----------------------------------------------------------------------------
--
--  Module:           xtmPlan
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmPlan.c.
--
--  Filename:         xtmPlan.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-06-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmPlan.h, Version: 1.1, Date: 95/02/18 15:52:38 */


/* Only include this module once. */
#ifndef define_xtmPlan_h
#  define define_xtmPlan_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "TimDate.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_PL_REASON_DESTROY,
  XTM_PL_REASON_EXIT
} XTM_PL_REASON;

/* Handle to use when comminucating with the planner window. */
typedef  void  *XTM_PL_HANDLE;

/* Callback when the planner window is cahnged. */
typedef void ( *XTM_PL_ACTION_CB ) ( XTM_PL_REASON, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmPlDestroy( XTM_PL_HANDLE  plan_handle );

void
  xtmPlEmptyCache();

XTM_PL_HANDLE
  xtmPlInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                toplevel,
                   XTM_PL_ACTION_CB      actionCB,
                   void                  *user_data );

void
  xtmPlViewPlanner( XTM_PL_HANDLE  plan_handle,
                    TIM_TIME_REF   start_date,
                    Boolean        iconic );

#endif
