/*----------------------------------------------------------------------------
--
--  Module:           xtmFormat
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for the xtmFormat module.
--
--  Filename:         xtmFormat.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-01-07
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmFormat.h, Version: 1.1, Date: 95/02/18 15:52:21 */


/* Only include this file once. */
#ifndef define_xtmFormat_h
#  define define_xtmFormat_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "xtmDbTools.h"
#include "TimDate.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Fetch what date and time. */
typedef enum {
  XTM_FO_START_DATE,
  XTM_FO_END_DATE,
  XTM_FO_START_TIME,
  XTM_FO_END_TIME
} XTM_FO_FETCH_WHAT;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

Boolean
  xtmFoFetchDate( Widget             parentW,
                  Widget             dateW,
                  XTM_FO_FETCH_WHAT  fetch_what,
                  Boolean            empty_allowed,
                  TIM_TIME_REF       *use_time );

Boolean
  xtmFoFetchMinuteTime( char     *char_ref,
                        Boolean  empty_allowed,
                        Widget   parent,
                        int      max_minutes,
                        int      *minutes );

Boolean
  xtmFoFetchTime( Widget             parentW,
                  Widget             timeW,
                  XTM_FO_FETCH_WHAT  fetch_what,
                  Boolean            empty_allowed,
                  TIM_TIME_REF       *use_time );

void
  xtmFoFormatDate( TIM_TIME_REF  use_time,
                   char          *buffer,
                   int           buffer_size );

void
  xtmFoFormatEntryFlags( XTM_GL_CUSTOM_DATA_REF  custom_data,
                         XTM_DB_ALL_ENTRY_REF    entry_record,
                         char                    *flags_buffer,
                         int                     flags_buffer_size );

void
  xtmFoFormatEntryTimes( XTM_DB_ALL_ENTRY_REF  entry_record,
                         char                  *time_buffer,
                         int                   time_buffer_size );

void
  xtmFoFormatFullTime( TIM_TIME_REF  use_time,
                       char          *buffer,
                       int           buffer_size );

char
  *xtmFoFormatText( char  *format_text,
                    int   indent,
                    int   max_lines,
                    int   max_line_length );

void
  xtmFoFormatTime( TIM_TIME_REF  use_time,
                   char          *buffer,
                   int           buffer_size );

#endif
