/*----------------------------------------------------------------------------
--
--  Module:           xtmEntryClip
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmEntryClip.
--
--  Filename:         xtmEntryClip.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-08-24
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmEntryClip.h, Version: 1.1, Date: 95/02/18 15:52:20 */


/* Include this module only once. */
#ifndef define_xtmEntryClip_h
#  define define_xtmEntryClip_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "xtmDbTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

Boolean
  xtmEcIsClipboardEmpty();

Boolean
  xtmEcRetrieveEntry( XTM_DB_ALL_ENTRY_DEF  *entry,
                      char                  **entry_text );

void
  xtmEcSaveEntry( XTM_DB_ALL_ENTRY_DEF  *entry,
                  char                  *entry_text );

#endif
