/*----------------------------------------------------------------------------
--
--  Module:           xtmCalDb
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmCalDb.
--
--  Filename:         xtmCalDb.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-07-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmCalDb.h, Version: 1.1, Date: 95/02/18 15:51:57 */


/* Include this file only once. */
#ifndef define_xtmCalDb_h
#  define define_xtmCalDb_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Flags for a calendar entry. */
#define XTM_CD_FLAG_ALARM               (1<<0)
#define XTM_CD_FLAG_DEFAULT_DB          (1<<1)
#define XTM_CD_FLAG_DEFAULT_START_ICON  (1<<2)
#define XTM_CD_FLAG_DEFAULT_START_WIN   (1<<3)
#define XTM_CD_FLAG_NOTIFY              (1<<4)
#define XTM_CD_FLAG_HIDE_IN_CAL         (1<<5)
#define XTM_CD_FLAG_IS_INCLUDED         (1<<6)
#define XTM_CD_FLAG_IS_EXTERNAL         (1<<7)
#define XTM_CD_FLAG_HAS_EXTERNAL_PWD    (1<<8)


/* Max number of calendars that can be included. */
#define XTM_CD_MAX_CAL_INCL       40


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Handle to use when comminucating with the calendar db. */
typedef  void  *XTM_CD_HANDLE;


/* Calendar included in a day view. */
typedef struct {

  /* Name of calendar. */
  char  name[ XTM_GL_MAX_CAL_NAME + 1 ];

} XTM_CD_INCL_CAL;


/* List of calendars included within another calendar. */
typedef struct {

  /* Number of calendars. */
  int  no;

  /* Included calendars. */
  XTM_CD_INCL_CAL  db[ XTM_CD_MAX_CAL_INCL ];

} XTM_CD_INCL_CALS, *XTM_CD_INCL_CALS_REF;


/* Data structure describing one calendar database. */
typedef struct {

  /* Do we have external password. */
  Boolean  has_extern_pwd;

  /* Owner UID. */
  int  owner_uid;

  /* Stacking order for windows. */
  int  win_stack_order;

  /* Flags. */
  UINT32  flags;

  /* Operation mode. */
  UINT32  operations;

  /* Name of the database. */
  char  short_name[ XTM_GL_MAX_CAL_NAME + 1 ];

  /* Directory. */
  char  directory[ XTM_GL_MAX_DIR + 1 ];

  /* External host. */
  char  extern_host[ XTM_GL_MAX_HOSTNAME + 1 ];

  /* External password. */
  char  extern_pwd[ XTM_GL_MAX_PASSWORD + 1 ];

  /* External user ID. */
  char  extern_uid[ XTM_GL_MAX_USERID + 1 ];

  /* External connection type. */
  char  extern_type[ XTM_GL_MAX_EXTERN_TYPE + 1 ];

  /* Mail address to owner of database. */
  char  mail_address[ XTM_GL_MAX_MAIL_ADDR ];

  /* Display entries with these tags in the day view. */
  char  view_tags[ 56 ];

  /* Alarms for entries with these tags. */
  char  alarm_tags[ 56 ];

  /* Color to use when displaying the database. */
  int  incl_bg_index;
  int  normal_bg_index;

  /* Include these databses in the view. */
  XTM_CD_INCL_CALS_REF  include;

  /* Extra space. */
  void  *extra1;
  void  *extra2;
  void  *extra3;
  void  *extra4;
  void  *extra5;
  void  *extra6;

} XTM_CD_CAL_INFO;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmCdAddDatabase( XTM_CD_HANDLE  cal_handle,
                    char           *cal_db_name,
                    char           *location,
                    UINT32         flags );

Boolean
  xtmCdAddEntry( XTM_CD_HANDLE     cal_handle,
                 XTM_CD_CAL_INFO   *db_info_ref,
                 XTM_CD_INCL_CALS  *db_incl_ref );

Boolean
  xtmCdChangeEntry( XTM_CD_HANDLE     cal_handle,
                    char              *cal_db_name,
                    XTM_CD_CAL_INFO   *new_db_info_ref,
                    XTM_CD_INCL_CALS  *new_db_incl_ref );

XTM_CD_HANDLE
  xtmCdCopy( XTM_CD_HANDLE  cal_handle );

Boolean
  xtmCdCreateShadowEntry( XTM_CD_HANDLE  cal_handle,
                          char           *cal_db_name,
                          char           *shadow_db_name );

Boolean
  xtmCdDeleteEntry( XTM_CD_HANDLE  cal_handle,
                    char           *cal_db_name );

Boolean
  xtmCdFetchDbNames( XTM_CD_HANDLE  cal_handle,
                     char           **db_names );

Boolean
  xtmCdFetchDefaultDb( XTM_CD_HANDLE     cal_handle,
                       XTM_CD_CAL_INFO   *db_info_ref,
                       XTM_CD_INCL_CALS  *db_incl_ref );

Boolean
  xtmCdFetchNamedDb( XTM_CD_HANDLE     cal_handle,
                     char              *cal_db_name,
                     XTM_CD_CAL_INFO   *db_info_ref,
                     XTM_CD_INCL_CALS  *db_incl_ref );

void
  xtmCdFree( XTM_CD_HANDLE  cal_handle );

Boolean
  xtmCdFreeShadowEntry( XTM_CD_HANDLE  cal_handle,
                        char           *shadow_db_name );

XTM_CD_HANDLE
  xtmCdInitialize();

Boolean
  xtmCdSearchIncludeDb( XTM_CD_INCL_CALS  *db_incl_ref,
                        char              *cal_db_name );


#endif
