/*----------------------------------------------------------------------------
--
--  Module:           msgXdiary
--
--  Project:          Xdiary
--  System:           msg - Message catalogue
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Message catalogue for text domain Xdiary.
--
--  Filename:         msgXdiary.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-03-12
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: msgXdiary.c, Version: 1.3, Date: 95/06/25 20:05:08";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Xdiary text domain messages. */
char *msgXdiaryTexts[] = {
  /*    0 */ "Ok",
  /*    1 */ "Cancel",
  /*    2 */ "Move/Copy entry to:",
  /*    3 */ "Date select",
  /*    4 */ "Error messages",
  /*    5 */ "Select hidden...",
  /*    6 */ "h",
  /*    7 */ "Invalid date!\n"
             " \n"
             "The date should be in the format\n"
             "yyyy-mm-dd or mm/dd/yyyy when using\n"
             "US date format.",
  /*    8 */ "Move/Copy Entry",
  /*    9 */ "Apply",
  /*   10 */ "Summary",
  /*   11 */ "Invalid date(s) given!\n"
             " \n"
             "The date should be in the format\n"
             "yyyy-mm-dd or mm/dd/yyyy when using\n"
             "US date format."
             " \n"
             "The first date should be earlier\n"
             "than the second date.",
  /*   12 */ "XDiary error message log:",
  /*   13 */ "Access...",
  /*   14 */ "Summary of appointments:",
  /*   15 */ "Between dates:",
  /*   16 */ "Appointment Editor",
  /*   17 */ "File",
  /*   18 */ "F",
  /*   19 */ "Help",
  /*   20 */ "H",
  /*   21 */ "Exit",
  /*   22 */ "x",
  /*   23 */ "Clear",
  /*   24 */ "Explanation",
  /*   25 */ "Invalid time!\n"
             " \n"
             "The time should be in the format\n"
             "HH:MM. If you are using US time\n"
             "format, you should add am/pm after\n"
             "the time.",
  /*   26 */ "Invalid time!\n \n"
             "The time should be given in the\n"
             "format DD HH:MM, HH:MM or MM\n"
             "where DD is days, HH is hours\n"
             "and MM is minutes.",
  /*   27 */ "View",
  /*   28 */ "The user does not exist!",
  /*   29 */ "The group does not exist!",
  /*   30 */ "You must define one or\n"
             "more access flags!",
  /*   31 */ "You must select at least\n"
             "one valid day!",
  /*   32 */ "Note",
  /*   33 */ "Start time:",
  /*   34 */ "Duration (HH:MM):",
  /*   35 */ "Reminder alarm",
  /*   36 */ "Note",
  /*   37 */ "Private",
  /*   38 */ "Important",
  /*   39 */ "Edit",
  /*   40 */ "Valid days:",
  /*   41 */ "E",
  /*   42 */ "Copy",
  /*   43 */ "C",
  /*   44 */ "You must select a printer!",
  /*   45 */ "Printer:",
  /*   46 */ "Type:",
  /*   47 */ "Alarms",
  /*   48 */ "Actions",
  /*   49 */ "A",
  /*   50 */ "Preferences...",
  /*   51 */ "Repeat when...",
  /*   52 */ "Preferences",
  /*   53 */ "Alarms (Days HH:MM):\n"
             "(leave blank if no alarm)",
  /*   54 */ "Before",
  /*   55 */ "After",
  /*   56 */ "Alarm tune",
  /*   57 */ "Recipient list:",
  /*   58 */ "Alarms...",
  /*   59 */ "Melody",
  /*   60 */ "Play\n"
             "melody", 
  /*   61 */ "Entry color, Fg / Bg:",
  /*   62 */ "Color sample",
  /*   63 */ "Select a Calendar",
  /*   64 */ "Print...",
  /*   65 */ "P",
  /*   66 */ "Collection of...",
  /*   67 */ "...calendars",
  /*   68 */ "Show summary...",
  /*   69 */ "S",
  /*   70 */ "Select...",
  /*   71 */ "Sticky note",
  /*   72 */ "Delete",
  /*   73 */ "Position in list:",
  /*   74 */ "Yes",
  /*   75 */ "Customize XDiary...",
  /*   76 */ "C",
  /*   77 */ "Edit appointment...",
  /*   78 */ "E",
  /*   79 */ "Month",
  /*   80 */ "Year",
  /*   81 */ "Calendar:",
  /*   82 */ "Appointment",
  /*   83 */ "Open day view...",
  /*   84 */ "O",
  /*   85 */ "No text for the entry!\n"
             " \n"
             "Appointments or notes without text\n"
             "cannot be saved. If you want to save\n"
             "the entry, add some text to the entry.",
  /*   86 */ "Appointments",
  /*   87 */ "Day",
  /*   88 */ "Print",
  /*   89 */ "For a repeated entry or a sticky\n"
             "note, you must select when the\n"
             "entry should be valid.",
  /*   90 */ "No",
  /*   91 */ "Paper format:",
  /*   92 */ "Entry list,Month list,Week list,Short week list,"
             "Day list,Short day list",
  /*   93 */ "A3,A4,A5,Letter,Legal",
  /*   94 */ "Send output to:",
  /*   95 */ "Printer,File,Printer & File",
  /*   96 */ "Select the calendars and groups and "
             "click on Apply to see the schedule.",
  /*   97 */ "New calendar:",
  /*   98 */ "Output has been saved in the file\n%s.",
  /*   99 */ "Information",
  /*  100 */ "Output has been sent to the printer",
  /*  101 */ "Valid on the days:",
  /*  102 */ "Delete Entry",
  /*  103 */ "The entry will be deleted!\nPress Ok to confirm.",
  /*  104 */ "Working",
  /*  105 */ "Working....\nPress Cancel to abort.",
  /*  106 */ "Select all",
  /*  107 */ "Clear all",
  /*  108 */ "Note done",
  /*  109 */ "All",
  /*  110 */ "Select calendar:",
  /*  111 */ "Repeated entries",
  /*  112 */ "Notes",
  /*  113 */ "Notes done",
  /*  114 */ "Notes not done",
  /*  115 */ "Search string:",
  /*  116 */ "File for printer out cannot\n"
             "be opened. Check your HOME\n"
             "environment variable.",
  /*  117 */ "Interval:\n"
             "(leave blank if no interval)",
  /*  118 */ "Copy",
  /*  119 */ "Move",
  /*  120 */ "Entry flags",
  /*  121 */ "Display flags and calendars for entries\n"
             "in the day view?\n"
             " \n"
             "The flags indicates various attributes\n"
             "for the entry, for example if alarms are\n"
             "defined, importance etc. Entries from\n"
             "included calendars display the name of\n"
             "the calendar where the entry is defined.",
  /*  122 */ "You cannot duplicate an\n"
             "appointment more than 65 days!",
  /*  123 */ "You cannot print/show more\n"
             "than 366 days!",
  /*  124 */ "Save in calendar:",
  /*  125 */ "Message Recipients",
  /*  126 */ "Send",
  /*  127 */ "To user:",
  /*  128 */ "Alarm",
  /*  129 */ "Display flags",
  /*  130 */ "f",
  /*  131 */ "Duplicate Entry",
  /*  132 */ "From:",
  /*  133 */ "until:",
  /*  134 */ "Do you want to duplicate\n"
             "the selected entry?",
  /*  135 */ "Comp msg...",
  /*  136 */ "Duplicate appointment %s.",
  /*  137 */ "Primary selection",
  /*  138 */ "Secondary selection",
  /*  139 */ "X buffer",
  /*  140 */ "Clipboard",
  /*  141 */ "Cut",
  /*  142 */ "Copy",
  /*  143 */ "Paste",
  /*  144 */ "Lines per entry in the:",
  /*  145 */ "Day view:",
  /*  146 */ "Alarm window:",
  /*  147 */ "Select the recipients of the XDiary message.\n"
             "A recipient can be a calendar, group of calendars\n"
             "or a mail address.",
  /*  148 */ "Calendars:",
  /*  149 */ "Groups:",
  /*  150 */ "Calendar/Mail address:",
  /*  151 */ "The directory\n"
             "%s\n"
             "cannot be created!\n \n"
             "Program aborting?",
  /*  152 */ "After you have added all recipients, click\n"
             "on <Comp msg> to open the message window.",
  /*  153 */ "The XDiary calendar in directory\n"
             "%s\n"
             "cannot be created!\n \n"
             "Program aborting?",
  /*  154 */ "To group:",
  /*  155 */ "W",
  /*  156 */ "Mo Tu We Th Fr Sa Su",
  /*  157 */ "Customize",
  /*  158 */ "Calendar:",
  /*  159 */ "Name:",
  /*  160 */ "Location:",
  /*  161 */ "Add recipient",
  /*  162 */ "Customize Message Groups",
  /*  163 */ "Customize Calendars",
  /*  164 */ "Customize Archive",
  /*  165 */ "Search tag:",
  /*  166 */ "If you have made any changes\n"
             "to your customization, the\n"
             "changes will not be saved!\n"
             " \n"
             "Is this Ok?",
  /*  167 */ "Compose Message",
  /*  168 */ "Select one or more calendars to include.\n \n"
             "The calendar(s) you include will be visible in the\n"
             "day view window, the summary window and the print\n"
             "window.\n ",
  /*  169 */ "Add",
  /*  170 */ "Add/Change",
  /*  171 */ "Delete",
  /*  172 */ "Only as mail",
  /*  173 */ "Calendar View",
  /*  174 */ "Mail if failure",
  /*  175 */ "Starting program...\n \n"
             "Please be patient.",
  /*  176 */ "Close window",
  /*  177 */ "C",
  /*  178 */ "Here you can customize various parts of XDiary.\n \n"
             "When you are done with the customization, click\n"
             "on Save or Ok to save your changes.\n ",
  /*  179 */ "The requested entry is not in\n"
             "the calendar!\n"
             "Perhaps it is already removed?",
  /*  180 */ "Attached remark:",
  /*  181 */ "You must enter both the name\n"
             "and the location of the calendar!",
  /*  182 */ "Date:",
  /*  183 */ "The location for the calendar you\n"
             "have selected is not known!\n \n"
             "Enter the location of the calendar\n"
             "in the Location field.",
  /*  184 */ "Pick calendar...",
  /*  185 */ "Active alarms",
  /*  186 */ "Close",
  /*  187 */ "Active alarms...",
  /*  188 */ "A",
  /*  189 */ "Text:",
  /*  190 */ "A command pipe cannot be opened\n"
             "for the communication with the\n"
             "alarm process. Make sure you have\n"
             "write permission in the /tmp\n"
             "directory.",
  /*  191 */ "Help",
  /*  192 */ "Cannot create another process!",
  /*  193 */ "Cannot find file to execute!",
  /*  194 */ "Confirm",
  /*  195 */ "No more",
  /*  196 */ "Repeat",
  /*  197 */ "Delete",
  /*  198 */ "Recipient:",
  /*  199 */ "Appointments",
  /*  200 */ "Cannot save custom data\nto file",
  /*  201 */ "Error",
  /*  202 */ "Tag:",
  /*  203 */ "New\nnote",
  /*  204 */ "Repeat",
  /*  205 */ "Repeat alarm in minutes:",
  /*  206 */ "minutes",
  /*  207 */ "Print",
  /*  208 */ "Archive...",
  /*  209 */ "Selected Monday Tuesday Wednesday Thursday "
             "Friday Saturday Sunday",
  /*  210 */ "The calendar you specified does\n"
             "not exist or you do not have\n"
             "access to the calendar.",
  /*  211 */ "Error Message",
  /*  212 */ "Archive",
  /*  213 */ "Archives:",
  /*  214 */ "Archive name:",
  /*  215 */ "Archive file:",
  /*  216 */ "Sticky notes and repeated\n"
             "entries cannot be archived!",
  /*  217 */ "The entry is already\n"
             "archived!",
  /*  218 */ "Cannot open the archive\n"
             "file for write. Check the\n"
             "file permissions!",
  /*  219 */ "Archive entry in:",
  /*  220 */ "Refresh",
  /*  221 */ "f",
  /*  222 */ "The custom data has\n"
             "been saved in the file\n"
             "%s.",
  /*  223 */ "Info Message",
  /*  224 */ "The alarm process cannot be\n"
             "started for XDiary!\n \n"
             "Check if directories and files\n"
             "exist and have correct permissions.",
  /*  225 */ "Cannot send command to the\n"
             "alarm process!",
  /*  226 */ "UNIX Access Control",
  /*  227 */ "New\nentry",
  /*  228 */ "You have not selected any\n"
             "recipients!\n"
             " \n"
             "Go back to the Recipient\n"
             "window and select one or\n"
             "more recipients.",
  /*  229 */ "Save",
  /*  230 */ "User (* - all users):",
  /*  231 */ "Group (* - all groups):",
  /*  232 */ "Read",
  /*  233 */ "Write",
  /*  234 */ "Note done",
  /*  235 */ "No of lines per entry:",
  /*  236 */ "%s\n \nTime    : %s\nDuration: %s\n \n%s",
  /*  237 */ "Case sensitive",
  /*  238 */ "Send message...",
  /*  239 */ "",
  /*  240 */ "Receive message...",
  /*  241 */ "",
  /*  242 */ "Message has been sent\n"
             "to the requested users\n"
             "and groups.",
  /*  243 */ "Cannot send message to %s!",
  /*  244 */ "Cannot send message to %s!\n"
             "Trying mail instead.",
  /*  245 */ "Message Selection",
  /*  246 */ "Messages:",
  /*  247 */ "Mail:",
  /*  248 */ "Answer",
  /*  249 */ "Hide the entry in:",
  /*  250 */ "Question",
  /*  251 */ "Do you want to delete\n"
             "the message?",
  /*  252 */ "Members (separated by a space):",
  /*  253 */ "Read Message",
  /*  254 */ "Answer Message",
  /*  255 */ "Message",
  /*  256 */ "Refresh",
  /*  257 */ "Groups:",
  /*  258 */ "Group name:",
  /*  259 */ "Make master plan...",
  /*  260 */ "p",
  /*  261 */ "Parameters...",
  /*  262 */ "Day view tags",
  /*  263 */ "Alarm tags",
  /*  264 */ "Calendars...",
  /*  265 */ "Message groups...",
  /*  266 */ "General parameters...",
  /*  267 */ "Archives...",
  /*  268 */ "Access control...",
  /*  269 */ "Calendar",
  /*  270 */ "Repeat When",
  /*  271 */ "Valid between the dates:\n"
             "(leave blank if all dates are valid)",
  /*  272 */ "Days",
  /*  273 */ "Weeks",
  /*  274 */ "Months",
  /*  275 */ "Years",
  /*  276 */ "Every:",
  /*  277 */ "Include calendar...",
  /*  278 */ "I",
  /*  279 */ "Include Calendar",
  /*  280 */ "Select calendars to include:",
  /*  281 */ "You must have at least one\n"
             "calendar defined!",
  /*  282 */ "Your settings will take effect the\n"
             "next time you start XDiary.",
  /*  283 */ "Edit access...",
  /*  284 */ "Include in Calendar %s",
  /*  285 */ "Not included:",
  /*  286 */ "Included:",
  /*  287 */ "Include",
  /*  288 */ "Day view",
  /*  289 */ "Remove",
  /*  290 */ "Include...",
  /*  291 */ "Hide",
  /*  292 */ "    ",
  /*  293 */ "AFS user or group:",
  /*  294 */ "AFS Access Control",
  /*  295 */ "You have made changes that have not been saved.\n \n"
             "If you add or change an entry, you must save\n"
             "the changes by clicking on the Add button. If\n"
             "you do not do this, your changes will not be saved.\n"
             " \n"
             "Do you still want to exit the window?",
  /*  296 */ "Cannot get a lock for the calendar.\n"
             "Check the file dbLock in the calendar\n"
             "directory.",
  /*  297 */ "Cannot open the calendar / cannot lock the\n"
             "calendar for read or write access. Check the\n"
             "calendar directory and the lock file dbLock.",
  /*  298 */ "Cannot insert entry in calendar.",
  /*  299 */ "Summary window",
  /*  300 */ "You do not have access to the calendar.\n"
             "Check file permissions and access rights.",
  /*  301 */ "Cannot generate unique entry ID.",
  /*  302 */ "Cannot delete entry from calendar.",
  /*  303 */ "Print window",
  /*  304 */ "Cannot fetch entry from calendar.",
  /*  305 */ "Dump output",
  /*  306 */ "Cannot fetch entries in the\n"
             "%s calendar.",
  /*  307 */ "App pane height",
  /*  308 */ "This is the height (in pixels) of the\n"
             "appointments window in the day view.\n"
             " \n"
             "See also <Entry pane width> and\n"
             "<Note pane height>.",
  /*  309 */ "This version of XDiary needs a custom\n"
             "file with version %d but another custom\n"
             "file was found.\n"
             " \n"
             "Please use the correct custom file and\n"
             "restart XDiary.",
  /*  310 */ "You do not have access to the\n"
             "calendar %s.\n"
             "Check file permissions and access rights.",
  /*  311 */ "Cannot create base database.",
  /*  312 */ "Cannot create repeated entries database.",
  /*  313 */ "Cannot create private entries database.",
  /*  314 */ "Cannot create id file.",
  /*  315 */ "Cannot execute process %s.",
  /*  316 */ "Error in regular expression.",
  /*  317 */ "Do not understand the line:",
  /*  318 */ "Error in holiday date.",
  /*  319 */ "Entry pane width",
  /*  320 */ "The width (in pixels) of the window\n"
             "containing the entries in the day\n"
             "view.\n"
             " \n"
             "See also <Note pane height> and\n"
             "<App pane height>.",
  /*  321 */ "The entry is deleted.\n"
             " \n"
             "To make sure your calendar and day\n"
             "view(s) are up-to-date, do:\n"
             " \n"
             "  * In the main calendar menu, select\n"
             "    Actions -> Refresh.\n",
  /*  322 */ "The entry has been\n"
             "saved in the calendar.",
  /*  323 */ "Day view",
  /*  324 */ "Day view for: %s",
  /*  325 */ "Date range: ",
  /*  326 */ "Week",
  /*  327 */ "Filter...",
  /*  328 */ "F",
  /*  329 */ "Prompt repeat",
  /*  330 */ "When a repeated entry is added,\n"
             "make sure the window containing the\n"
             "definitions when the entry is valid.",
  /*  331 */ "Today",
  /*  332 */ "Define the filter you want to use. You can select\n"
             "the type of entries, search for a string in the entry\n"
             "text or search for a tag.\n ",
  /*  333 */ "Entries interactive",
  /*  334 */ "If you want to be able to move\n"
             "and resize entries with the mouse,\n"
             "set the parameter to Yes.",
  /*  335 */ "Filter",
  /*  336 */ "Type of entry (OR):",
  /*  337 */ "Start day view on",
  /*  338 */ "When you open a day view, always\n"
             "start on the following day.\n"
             " \n"
             "If you change this parameter from\n"
             "the default value, make sure that\n"
             "your day view display a sufficient\n"
             "number of days.\n"
             " \n"
             "See also <Day view day switch>.",
  /*  339 */ "Calendar Notify",
  /*  340 */ "The following XDiary calendars have\n"
             "been changed:",
  /*  341 */ "Reminder",
  /*  342 */ "Reminders:",
  /*  343 */ "Active",
  /*  344 */ "Hour:Minute for reminder %d",
  /*  345 */ "Cannot parse or allocate color\n"
             " <%s>\n",
  /*  346 */ "Reset",
  /*  347 */ "Reminder Alarm",
  /*  348 */ "Set reminder...",
  /*  349 */ "m",
  /*  350 */ "On Context",
  /*  351 */ "C",
  /*  352 */ "On Window",
  /*  353 */ "W",
  /*  354 */ "On Keys",
  /*  355 */ "K",
  /*  356 */ "Index",
  /*  357 */ "I",
  /*  358 */ "On Help",
  /*  359 */ "H",
  /*  360 */ "On Version",
  /*  361 */ "V",
  /*  362 */ "When alarm",
  /*  363 */ "sounds, then do:",
  /*  364 */ "Call default program (script)",
  /*  365 */ "Use entry text as shell script",
  /*  366 */ "Skip this week (%d)?",
  /*  367 */ "Skip weeks...",
  /*  368 */ "Skip Weeks",
  /*  369 */ "Skip this entry in the weeks:",
  /*  370 */ "Reset",
  /*  371 */ "You have not selected\na calendar!",
  /*  372 */ "Welcome to XDiary!\n"
             " \n"
             "Before you can use XDiary you will need a default\n"
             "calendar. The default XDiary calendar will be\n"
             "created in your home directory as:\n"
             " \n"
             "  ($HOME/Diary).\n"
             " \n"
             "Should I try to create the default calendar?",
  /*  373 */ "XDiary setup:\n"
             " \n"
             "You have the diary calendar %s defined\n"
             "as your default calendar and you do not have\n"
             "read access to this calendar.\n"
             " \n"
             "Please check the file permissions in the\n"
             "directory %s\n"
             "and restart XDiary.",
  /*  374 */ "Setup",
  /*  375 */ "Message from",
  /*  376 */ "Repeated appointment",
  /*  377 */ "Repeated note",
  /*  378 */ "%s entry to\n%s %s?",
  /*  379 */ "You cannot do this for\n"
             "repeated and sticky entries!",
  /*  380 */ "Delete",
  /*  381 */ "D",
  /*  382 */ "Move",
  /*  383 */ "M",
  /*  384 */ "Duplicate",
  /*  385 */ "u",
  /*  386 */ "Archive",
  /*  387 */ "A",
  /*  388 */ "Copy entry",
  /*  389 */ "o",
  /*  390 */ "Cut entry",
  /*  391 */ "t",
  /*  392 */ "Paste entry",
  /*  393 */ "P",
  /*  394 */ "Navigate...",
  /*  395 */ "N",
  /*  396 */ "Pick a Day",
  /*  397 */ "Change duration for\nappointment to %d:%02d?",
  /*  398 */ "Confirm actions",
  /*  399 */ "C",
  /*  400 */ "Display list layout",
  /*  401 */ "l",
  /*  402 */ "Use grid",
  /*  403 */ "U",
  /*  404 */ "Controls",
  /*  405 */ "C",
  /*  406 */ "Open same",
  /*  407 */ "O",
  /*  408 */ "New view...",
  /*  409 */ "N",
  /*  410 */ "Include a file...",
  /*  411 */ "I",
  /*  412 */ "Directories",
  /*  413 */ "Files",
  /*  414 */ "Filter",
  /*  415 */ "Selection",
  /*  416 */ "You have not selected\n"
             "a file!",
  /*  417 */ "This file cannot\n"
             "be read!",
  /*  418 */ "Display days...",
  /*  419 */ "D",
  /*  420 */ "Display Days",
  /*  421 */ "No of days to display:",
  /*  422 */ "Show overlapping",
  /*  423 */ "o",
  /*  424 */ "Color when included:",
  /*  425 */ "Edit",
  /*  426 */ "My editor...",
  /*  427 */ "UNIX Acl",
  /*  428 */ "Custom",
  /*  429 */ "Remind",
  /*  430 */ "Send",
  /*  431 */ "Read",
  /*  432 */ "Parameters:",
  /*  433 */ "Description:",
  /*  434 */ "Value:",
  /*  435 */ "On",
  /*  436 */ "Off",
  /*  437 */ "Defaults",
  /*  438 */ "This will overwrite the\n"
             "current values.\n"
             "Do you want to do this?",
  /*  439 */ "The value is not correct!\n"
             "See the description above\n"
             "for additional help.",
  /*  440 */ "Mail address",
  /*  441 */ "Mail address to use if appointment\n"
             "cannot be sent as an XDiary message.",
  /*  442 */ "View tags",
  /*  443 */ "In the day view, display only entries\n"
             "containing these tags.\n"
             " \n"
             "You can define more than one tag\n"
             "(separate them with a space). Each entry\n"
             "tag can be up to 4 characters.\n"
             " \n"
             "See also <Alarm tags>",
  /*  444 */ "Alarm tags",
  /*  445 */ "Sound only alarms for entries containing\n"
             "these tags.\n"
             " \n"
             "You can define more than one tag\n"
             "(separate them with a space). Each entry\n"
             "tag can be up to 4 characters.\n"
             " \n"
             "See also <View tags>.",
  /*  446 */ "Include color",
  /*  447 */ "If this calendar is included in a day\n"
             "view, use this color as background\n"
             "color.",
  /*  448 */ "Alarms",
  /*  449 */ "Start an alarm process for this\n"
             "calendar. If no alarm process is\n"
             "running, you will not get any alarms.",
  /*  450 */ "Default DB",
  /*  451 */ "Use this calendar as the default\n"
             "calendar. The default calendar is\n"
             "displayed in the main calendar window\n"
             "when you start XDiary.\n"
              " \n"
             "You should only have ONE default\n"
             "calendar defined.",
  /*  452 */ "Start icon",
  /*  453 */ "When XDiary is started, open a day view\n"
             "for this calendar. The day view window\n"
             "is displayed as an icon.\n"
             " \n"
             "See also <Start window>.",
  /*  454 */ "Start window",
  /*  455 */ "When XDiary is started, open a day view\n"
             "for this calendar.\n"
             " \n"
             "See also <Start icon>.",
  /*  456 */ "Notify changed",
  /*  457 */ "XDiary contains the program xdnotify\n"
             "which monitors one or more calendars\n"
             "for changes. This parameter allows you\n"
             "to select if this calendar should\n"
             "be monitored.",
  /*  458 */ "General...",
  /*  459 */ "Confirm",
  /*  460 */ "Display a confirmation dialog for\n"
             "dangerous actions like deleting an\n"
             "appointment etc.",
  /*  461 */ "Day view as list",
  /*  462 */ "In the day view, display the entries and\n"
             "appointments in list form.",
  /*  463 */ "Give alarms",
  /*  464 */ "For all calendars that have the Alarm\n"
             "flag defined, start an alarm process.\n",
  /*  465 */ "Monday day 1",
  /*  466 */ "Is Monday the first day in the week?\n"
             "(otherwise Sunday is the first day in\n"
             "the week)\n"
             " \n"
             "See also <US date/time>.",
  /*  467 */ "Navigate calendar",
  /*  468 */ "In the day view, display the navigate\n"
             "calendar every time a new day view is\n"
             "opened?",
  /*  469 */ "Repeated in calendar",
  /*  470 */ "Should days containing repeated entries\n"
             "be high-lighted in the calendar?",
  /*  471 */ "Summary at start-up",
  /*  472 */ "Display the summary window every time\n"
             "XDiary is started?",
  /*  473 */ "US date/time",
  /*  474 */ "Use the US date (MM/DD/YYYY) and time\n"
             "(HH:MM AM/PM). The other alternative\n"
             "is European date (YYYY-MM-DD) and\n"
             "time (HH:MM 24-hour format).\n"
             " \n"
             "See also <Monday day 1>.",
  /*  475 */ "Day view starts",
  /*  476 */ "The hour (0-23) when the day view\n"
             "starts.\n"
             " \n"
             "See also <Day view stops>.",
  /*  477 */ "Day view stops",
  /*  478 */ "The hour (0-23) when the day view\n"
             "stops."
             "See also <Day view starts>.",
  /*  479 */ "Day view days",
  /*  480 */ "The number of days to display in the\n"
             "day view when a new day view is opened.\n",
  /*  481 */ "Week numbers",
  /*  482 */ "Display week numbers in the main and\n"
             "navigate calendars.",
  /*  483 */ "Alarm lines",
  /*  484 */ "The default number of lines from an\n"
             "entry to display in the alarm window.\n"
             "This value can be changed for individual\n"
             "entries.",
  /*  485 */ "Entry lines",
  /*  486 */ "The default number of lines from an\n"
             "entry to display in the day view.\n"
             "This value can be changed for individual\n"
             "entries.",
  /*  487 */ "Entry delta",
  /*  488 */ "The number of minutes between each\n"
             "tick in the day view time scale.\n"
             " \n"
             "Valid values are between 5 minutes and\n"
             "360 minutes (6 hours).",
  /*  489 */ "Tune",
  /*  490 */ "The default tune assigned to all new\n"
             "entries.\n"
             "This value can be changed for individual\n"
             "entries.",
  /*  491 */ "Pages per sheet",
  /*  492 */ "1 2",
  /*  493 */ "Do refresh",
  /*  494 */ "XDiary can make periodic refreshs where\n"
             "calendars and day views are updated with\n"
             "the latest information from the\n"
             "calendar.\n"
             " \n"
             "See also <Refresh rate>.",
  /*  495 */ "Refresh rate",
  /*  496 */ "If automatic refresh is selected, do the\n"
             "refreshs with this minute interval.\n"
             "It is recommended that you keep the\n"
             "interval longer than 15 minutes.\n"
             "Automatic refresh can be selected with\n"
             "<Do refresh>.\n"
             " \n"
             "See also <Do refresh>.",
  /*  497 */ "Note pane height",
  /*  498 */ "This is the height (in pixels) of the\n"
             "note window in the day view.\n"
             " \n"
             "See also <Entry pane width> and\n"
             "<App pane height>.",
  /*  499 */ "Day width",
  /*  500 */ "The width of each day (in pixels).",
  /*  501 */ "Set day width...",
  /*  502 */ "w",
  /*  503 */ "Day width",
  /*  504 */ "The width of each day in the day view\n"
             "(in pixels). A width of 0 (zero) will\n"
             "use the default width.",
  /*  505 */ "Summary lines",
  /*  506 */ "The number of lines to display per\n"
             "entry in the summary window.",
  /*  507 */ "Print lines",
  /*  508 */ "The number of lines to print per entry\n"
             "when printing one or more calendars.",
  /*  509 */ "Cannot write temporary file!",
  /*  510 */ "Cannot read temporary file!",
  /*  511 */ "Alarm window",
  /*  512 */ "Cannot set process group!",
  /*  513 */ "Guess location",
  /*  514 */ "You must give the name of\n"
             "the calendar to look for!",
  /*  515 */ "Cannot find a calendar that\n"
             "matches the given name.",
  /*  516 */ "As mail",
  /*  517 */ "All your changes will be lost!\n"
             " \n"
             "Is this OK?",
  /*  518 */ "Day view day switch",
  /*  519 */ "At midnight, all opened day views can\n"
             "be updated to display today as the\n"
             "leftmost day.\n"
             " \n"
             "On which day during the week should\n"
             "this happen?\n"
             " \n"
             "See also <Start day view on>.",
  /*  520 */ "Daily Never Monday Tuesday Wednesday Thursday "
             "Friday Saturday Sunday",
  /*  521 */ "Reread custom file",
  /*  522 */ "R",
  /*  523 */ "Cancel and close",
  /*  524 */ "C",
  /*  525 */ "Save and close",
  /*  526 */ "S",
  /*  527 */ "Show",
  /*  528 */ "w",
  /*  529 */ "Show appointment...",
  /*  530 */ "w",
  /*  531 */ "Style:",
  /*  532 */ "Master Plan",
  /*  533 */ "Plan",
  /*  534 */ "Archive file:",
  /*  535 */ "Instant update",
  /*  536 */ "I",
  /*  537 */ "You have selected to\n"
             "exit XDiary!\n"
             " \n"
             "Is this Ok?",
  /*  538 */ "Select a printer:",
  /*  539 */ " To add a printer above, see Help -> On Window.",
  /*  540 */ "True colors included",
  /*  541 */ "You can assign a color of your choice\n"
             "to appointments and notes. When entries\n"
             "in an included calendar are displayed\n"
             "in the day view, you can select to see\n"
             "the true color of the entries. If not,\n"
             "all included entries will have the default\n"
             "calendar color.",
  /*  542 */ "Display true colors",
  /*  543 */ "t",
  /*  544 */ "Today",
  /*  545 */ "This week",
  /*  546 */ "This month",
  /*  547 */ "This year",
  /*  548 */ "Not this week",
  /*  549 */ "Entry info...",
  /*  550 */ "i",
  /*  551 */ "Entry type:  %s\n"
             "Calendar:  %s\n"
             "Last changed:  %s\n"
             "Last changed by:  %s\n",
  /*  552 */ "Display day view",
  /*  553 */ "The given time is outside\n"
             "the acceptable limits!",
  /*  554 */ "You can only tear off\n"
             "repeated entries!",
  /*  555 */ "Tear off Entry",
  /*  556 */ "For a repeated entry, you can tear off the\n"
             "entry a specific week and save it as a separate\n"
             "entry. The entry that was teared off does not keep\n"
             "any references to the repeated entry.\n"
             " \n"
             "You can also select to hide the repeated entry\n"
             "this week.\n"
             "\n "
             "Tear off entry and save it:",
  /*  557 */ "Skip this week",
  /*  558 */ "Tear off...",
  /*  559 */ "T",
  /*  560 */ "Calendar month extended",
  /*  561 */ "The calendars can display days from the\n"
             "previous and next month. The extra days\n"
             "are displayed in a different color.",
  /*  562 */ "Toggle extra days",
  /*  563 */ "x",
  /*  564 */ "XDiary Release Notes",
  /*  565 */ "You are using a new version of XDiary.\n"
             "If you want to know what has changed in\n"
             "this version, it is recommended that you\n"
             "read the release notes.\n"
             " \n"
             "Do you want to read the release notes?",
  /*  566 */ "Appointments",
  /*  567 */ "Notes",
  /*  568 */ "Reminder alarm",
  /*  569 */ "Important",
  /*  570 */ "Private",
  /*  571 */ "Note done",
  /*  572 */ "Note not done",
  /*  573 */ "Repeated",
  /*  574 */ "Sticky",
  /*  575 */ "Entries with properties (AND):",
  /*  576 */ "  Click on the day for the entry.",
  /*  577 */ "About XDiary",
  /*  578 */ "Default colors",
  /*  579 */ "Only owner can change entry",
  /*  580 */ "Only owner can delete entry",
  /*  581 */ "Hide in calendar",
  /*  582 */ "For this calendar, you can select if\n"
             "days with entries should be high-\n"
             "lighted in the calendar window when\n"
             "this calendar is included in another\n"
             "calendar.",
  /*  583 */ "Stacking order",
  /*  584 */ "For entries (from this calendar)\n"
             "in the day view, you can decide\n"
             "if they should be kept in the\n"
             "background, foreground or keep their\n"
             "default position.\n"
             " \n"
             "The stacking order is only important\n"
             "when you have overlapping appointments.",
  /*  585 */ "Default Foreground Background",
  /*  586 */ "Keep entry in background",
  /*  587 */ "Keep entry in foreground",
  /*  588 */ "Changed: %s %s\n"
             "Changed by: %s\n"
             " \n"
             "Changed entry:\n",
  /*  589 */ "XDiary version 3.0.1\n"
             " \n"
             "Crafted by:\n"
             "  Roger Larsson\n"
             "  E-mail: Roger.Larsson@ubs.com\n"
             " \n"
             "(C) Copyright Ulrika Bornetun, Roger Larsson (1995)\n"
             "    All rights reserved\n"
             " \n"
             "    See COPYRIGHT file for details.\n",
  /*  590 */ "About XDiary",
  /*  591 */ "A",
  /*  592 */ "Reminder for new entries",
  /*  593 */ "For new appointments, do you want\n"
             "reminders or not?",
  /*  594 */ "Refresh",
  /*  595 */ "Print only workdays",
  /*  596 */ "When you print entries, only print\n"
             "entries on working days (Monday -\n"
             "Friday)?",
  /*  597 */ "Print only workdays",
  /*  598 */ "Sunday Monday Tuesday Wednesday Thursday Friday Saturday",
  /*  599 */ "Monday Tuesday Wednesday Thursday Friday Saturday Sunday",
  /*  600 */ "Use 3D style",
  /*  601 */ "Print in 3D",
  /*  602 */ "When you print your calendars, use\n"
             "a 3D look?",
  /*  603 */ "Include files nested to deeply!",
  /*  604 */ "There exits an included calendar with\n"
             "the same name! Please select another name\n"
             "for the calendar!",
  /*  605 */ "There exits an included group with\n"
             "the same name! Please select another name\n"
             "for the group!",
  /*  606 */ "Edit",
  /*  607 */ "Select Hidden",
  /*  608 */ "Select the note or appointment you\n"
             "want to edit.",
  /*  609 */ "Add...",
  /*  610 */ "Error in date or time formats!\n"
             " \n"
             "Using default date and time formats.",
  /*  611 */ "Order:",
  /*  612 */ "MDY",
  /*  613 */ "DMY",
  /*  614 */ "YMD",
  /*  615 */ "Separator (no number):",
  /*  616 */ "Day leading 0 (07 vs 7)",
  /*  617 */ "Month leading 0 (02 vs 2)",
  /*  618 */ "Century (1993 vs 93)",
  /*  619 */ "Date format",
  /*  620 */ "Select the format when displaying\n"
             "and entering dates.\n"
             " \n"
             "The separator can be any character\n"
             "except 0-9 (it can also be empty).\n"
             " \n"
             "See also <Time format>.",
  /*  621 */ "12 hour  0:00 - 11:59 ",
  /*  622 */ "24 hour 12:00 - 23:59 ",
  /*  623 */ "Separator (no number):",
  /*  624 */ "Hour leading 0 (09:13 vs 9:13)",
  /*  625 */ "Time format",
  /*  626 */ "Select the format when displaying\n"
             "and entering times.\n"
             " \n"
             "The separator can be any character\n"
             "except 0-9 (it can also be empty).\n"
             " \n"
             "See also <Date format>.",
  /*  627 */ "Paper size",
  /*  628 */ "The default paper size you want to\n"
             "use in XDiary.",
  /*  629 */ "A3 A4 A5 Letter Legal",
  /*  630 */ "Change...",
  /*  631 */ "Remote host: ",
  /*  632 */ "Remote user: ",
  /*  633 */ "Password: ",
  /*  634 */ "Connection type: ",
  /*  635 */ "Script to run: ",
  /*  636 */ "Upload",
  /*  637 */ "Download",
  /*  638 */ "Upload",
  /*  639 */ "U",
  /*  640 */ "Download",
  /*  641 */ "D",
  /*  642 */ "Upload / download calendar %s",
  /*  643 */ "Here you can upload the current calendar to a remote\n"
             "host or download a calendar from the same host.",
  /*  644 */ "The upload or download process is now\n"
             "running in the background.",
  /*  645 */ "Type the password to use on\n"
             "the remote host.\n"
             " \n"
             "The password will not be echoed.",
  /*  646 */ "First day in week:",
  /*  647 */ "Sunday Monday",
  /*  648 */ "Is remote",
  /*  649 */ "If you want to upload and/or download\n"
             "this calendar from a remote host,\n"
             "select Yes below.\n"
             " \n"
             "Note that upload and download\n"
             "procedure for remote calendars must\n"
             "be customized by you or your XDiary\n"
             "administrator. See the XDiary help for\n"
             "more information about remote\n"
             "calendars.",
  /*  650 */ "Renote host",
  /*  651 */ "Name of the remote host.",
  /*  652 */ "Remote password",
  /*  653 */ "Password to use on the remote host.\n"
             " \n"
             "Note! The password will be saved in\n"
             "the file XDiary.custom in your home\n"
             "directory. Make sure that other users\n"
             "cannot read this file!",
  /*  654 */ "Remote type",
  /*  655 */ "Type of remote connection. See the XDiary\n"
             "help for more information about this\n"
             "parameter.",
  /*  656 */ "Remote user",
  /*  657 */ "The remote user ID to use on the remote\n"
             "host.",
  /*  658 */ "Enter a new value for the field.\n"
             " \n"
             "The text will not be echoed.",
  /*  659 */ "Date: ",
  /*  660 */ "Calendar: ",
  /*  661 */ "Dd",
  /*  662 */ "Ww",
  /*  663 */ "Mm",
  /*  664 */ "Yy",
  /*  665 */ "Pick date...",
  /*  666 */ "Now",
  /*  667 */ "Noon",
  /*  668 */ "Pick time...",
  /*  669 */ "+1 week",
  /*  670 */ "+2 weeks",
  /*  671 */ "+1 month",
  /*  672 */ "Pick start date...",
  /*  673 */ "Pick end date...",
  /*  674 */ "Appointments:",
  /*  675 */ "Notes:",
  /*  676 */ "Note:",
  /*  677 */ "Alarm program is dead!\n"
             " \n"
             "The program that supervises alarms for\n"
             "your calendar has stopped.\n"
             " \n"
             "If you want to restart it, select\n"
             "Files -> Active alarms in the main\n"
             "calendar window.",
  /*  678 */ "Sheets per page",
  /*  679 */ "Number of calendar sheets to print\n"
             "on a single page.",
  /*  680 */ "Import",
  /*  681 */ "You can add one the calendars below to your\n"
             "personal calendars:",
  /*  682 */ "Import Calendar",
  /*  683 */ "Import...",
  /*  684 */ "Every",
  /*  685 */ "1st,2nd,3rd,3rd last,2nd last,last",
  /*  686 */ "Interval when entry is valid:",
  /*  687 */ "in month",
  /*  688 */ "Valid on days",
  /*  689 */ "Entry intervals",
  /*  690 */ "Day,Week,Month,Month (last day),Year",
  /*  691 */ "If non-workday, do",
  /*  692 */ "keep,skip,next workday,prev workday",
  /*  693 */ "You must select one\n"
             "or more days in the week!",
  /*  694 */ "The start date\n"
             "is missing!",
  /*  695 */ "The interval between\n"
             "entries is missing!",
  /*  696 */ "Workdays",
  /*  697 */ "Select the workdays in the week.\n"
             " \n"
             "You must select at least one day!",
  /*  EOT */ NULL,
};


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

