# Pop-Imap (mail-fetching) Client Tcl code for tkgoodstuff
# Mark Crimmins (markcrim@umich.edu)

# define your preferred settings in .tkgoodstuffrc before invoking
# "Client PopImap"

set PopImap_interval 180
set PopImap_offset 2

# command to get new mail from Pop or Imap server
# (I use a hacked imapcopy, but popclient is useable; apparently there are 
# perl scripts that are quite flexible pop clients)
set PopImap_command ""

# command to entirely replace local mailbox with remote one (I use a
# different hacked imapcopy).
set PopImap_fetch_command ""

set popping 0

# Code to set up periodic PopImap popping
# (the client Net will do it on Net Up, so skip if Net is loaded)
if { [lsearch $Clients Net] == -1 } {
  set TKG_async_map(PopImap_pop) [list $PopImap_interval $PopImap_offset PopImap_do_pop]
}

proc PopImap_do_pop {} {
    global PopImap_command 
    global Clients Net_linkstatus global popping
    global TKGlogging PopImap_vigilance_interval PopImap_vigilance_offset

    if { ([lsearch $Clients Net] != -1 ) && !$Net_linkstatus } {
	DEBUG "Not checking for remote mail because net down."
	return
    }
    DEBUG "PopImap: $PopImap_command"
    eval exec $PopImap_command & 
    # start heightened Biff vigilance
    if { [lsearch $Clients Biff] != -1 } {
	Biff_vigilance
    }    
}

proc create-PopImap-window {} {
    global PopImap_fetch_command
    TKGPopupAddClient PopImap
    .tkgpopup.popimap add command\
	-label "Get NEW mail in remote mailbox" -command {PopImap_do_pop}
    if { $PopImap_fetch_command != "" } {
	.tkgpopup.popimap add command\
	    -label "Replace local with remote mailbox"\
	    -command {eval exec $PopImap_fetch_command &}
    }
}

DEBUG "Loaded PopImap.tcl"
