#include <stdio.h>
#include <stdlib.h>
#include <Xm/PushB.h>
#include <Xm/BulletinB.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

main(int argc, char *argv[])
{
    XtAppContext app;
    Widget top, bb, button;
    int status;
    Pixmap pixmap, armpixmap, mask;
    XpmAttributes attributes;
    XpmColorSymbol symbol;
    Dimension mt, mh, st, ht;

    top = XtAppInitialize(&app, "BulletButton", NULL, 0, &argc, argv,
			  NULL, NULL, 0);
    bb = XmCreateBulletinBoard(top, "bb", NULL, 0);
    button = XmCreatePushButton(bb, "button", NULL, 0);

    /* create a red bullet pixmap from the XPM file */
    status = XpmReadFileToPixmap(XtDisplay(top),
				 XRootWindowOfScreen(XtScreen(top)),
				 "bullet_transp.xpm", &pixmap, &mask, NULL);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }
    /* set the Foreground to green */
    symbol.name = "Foreground";
    symbol.value = "green";

    attributes.colorsymbols = &symbol;
    attributes.numsymbols = 1;
    attributes.valuemask = XpmColorSymbols;

    /* create a green bullet pixmap with these attributes */
    status = XpmReadFileToPixmap(XtDisplay(top),
				 XRootWindowOfScreen(XtScreen(top)),
				 "bullet_transp.xpm", &armpixmap, NULL,
				 &attributes);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }
    /* put the two pixmaps onto the button */
    XtVaSetValues(button,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, pixmap,
		  XmNarmPixmap, armpixmap,
		  NULL);
    XtManageChild(button);
    XtManageChild(bb);
    XtRealizeWidget(top);
    /* finally reshape the button window with the mask */
    XtVaGetValues(button,
		  XmNmarginTop, &mt,
		  XmNmarginHeight, &mh,
		  XmNshadowThickness, &st,
		  XmNhighlightThickness, &ht,
		  NULL);
    XShapeCombineMask(XtDisplay(button), XtWindow(button), ShapeBounding,
		      mt + mh + st + ht, mt + mh + st + ht,
		      mask, ShapeSet);

    XtAppMainLoop(app);
}
