#include <stdio.h>
#include <stdlib.h>
#include <Xm/PushB.h>
#include <X11/xpm.h>

main(int argc, char *argv[])
{
    XtAppContext app;
    Widget top, button;
    int status;
    Pixmap pixmap;

    /* create a simple hierarchy with a PushButton widget */
    top = XtAppInitialize(&app, "BulletButton", NULL, 0, &argc, argv,
			  NULL, NULL, 0);
    button = XmCreatePushButton(top, "button", NULL, 0);

    /* create a pixmap from the XPM file */
    status = XpmReadFileToPixmap(XtDisplay(top),
				 XRootWindowOfScreen(XtScreen(top)),
				 "bullet.xpm", &pixmap, NULL, NULL);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }
    /* then put the pixmap onto the button */
    XtVaSetValues(button,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, pixmap,
		  NULL);
    XtManageChild(button);
    XtRealizeWidget(top);
    XtAppMainLoop(app);
}
