/*----------------------------------------------------------------------------
--
--  Module:           xmubUtils
--
--  Project:          <>
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Some useful functions.
--
--  Contents:
--    <>
--
--  Filename:         xmubUtils.c
--
--  Authors:          Ulrika Bornetun
--  Creation date:    1994-03-30
--
--  Modifications:
--
--  Who            When
--  What
--  -----------------------------
--  <>             <>
--  <>
--
--
--
--  Copyright 1994 by Union Bank of Switzerland.
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies.
--  Union Bank of Switzerland makes no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
--
------------------------------------------------------------------------------
--
-- SCCSID = "@(#) Module: %M%, Version: %R%.%L%, Date: %E% %U%"
--
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <Xm/Xm.h>

#ifdef VMS
#include "xmubUtils.h"
#else
#include <xmub/xmubUtils.h>
#endif

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xmubGetPopups( Widget       widget,
                 WidgetList  *list,
                 Cardinal    *num_popups )
{

  WidgetRec  *core_widget;  

  /* Code. */

  core_widget = (WidgetRec *) widget;

  *list       = core_widget -> core.popup_list;
  *num_popups = core_widget -> core.num_popups;


  return;

} /* xmubGetPopups */


/*----------------------------------------------------------------------*/

void
  xmubIterateTree( Widget          toplevel,
                   XtCallbackProc  callback,
                   XtPointer       client_data )
{

  Arg             args[ 8 ];
  WidgetList      children;
  Cardinal        kindex;
  Cardinal        n;
  Cardinal        num_children;
  Cardinal        num_popups;
  WidgetList      popup_list;

  /* Code. */

  /* Call the callback for the current widget. */
  ( *callback ) ( toplevel, NULL, client_data );

  /* Check children only for widgets. */
  if( ! XtIsWidget( toplevel ) )
    return;

  num_children = 0;

  n = 0;  
  XtSetArg( args[ n ], XmNchildren,    &children ); n++;
  XtSetArg( args[ n ], XmNnumChildren, &num_children ); n++;
  XtGetValues( toplevel, args, n );


  /* Loop for children. */

  for( kindex = 0; kindex < num_children; kindex ++ )
    xmubIterateTree( children[ kindex ], callback, client_data );

  /* Loop for popups. */
  xmubGetPopups( toplevel, &popup_list, &num_popups );

  for( kindex = 0; kindex < num_popups; kindex ++ )
    xmubIterateTree( popup_list[ kindex ], callback, client_data );


  return;

} /* xmubIterateTree */

