/*----------------------------------------------------------------------------
--
--  Module:           new_demo
--
--  Project:          <>
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Demo program to show resource set changes.
--    New interface.
--
--  Contents:
--    <>
--
--  Filename:         new_demo.c
--
--  Authors:          Ulrika Bornetun
--  Creation date:    1994-09-01
--
--  Modifications:
--
--  Who            When
--  What
--  -----------------------------
--  <>             <>
--  <>
--
--
--  Copyright 1994 by Union Bank of Switzerland.
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies.
--  Union Bank of Switzerland makes no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
------------------------------------------------------------------------------
--
-- SCCSID = "@(#) Module: %M%, Version: %R%.%L%, Date: %E% %U%"
--
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#include <X11/Intrinsic.h>

#if XlibSpecificationRelease > 4
#include <X11/Xlocale.h>
#endif

#include <Xm/Xm.h>

#include <Xm/Command.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/Text.h>

#ifdef VMS
#include "xmubCustUtil.h"
#else
#include <xmub/xmubCustUtil.h>
#endif

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

#define APP_CLASS        "NewDemo"

#if XmVersion < 1002
#define XmFONTLIST_DEFAULT_TAG  XmSTRING_DEFAULT_CHARSET
#endif

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

static XtAppContext                app;
static xmubResourceMappingInfoRef  mapping_ref;
static Widget                      toplevel;

/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/


void
  ChangeWidgetColorsCB( Widget     widget,
                        XtPointer  dummy,
                        XtPointer  update_shadows );

static void
  ChangePalette( xmubResourceMappingInfoRef  ref,
                 char*                       color_set );


static void 
  CommandCB( Widget                   widget,
             Widget                   text,
             XmCommandCallbackStruct  *call_data );

static void
PrintCommand( xmubResourceMappingInfoRef       ref,
              XtPointer                        widget,
              xmubResSetChangeCallbackStruct*  cb );

static void
UpdateColors( xmubResourceMappingInfoRef       ref,
              XtPointer                        widget,
              xmubResSetChangeCallbackStruct*  cb );


/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  main( int argc, char *argv[] )
{

  Arg               args[ 20 ];
  Display*          display;
  Widget            form, out_lb, out_tx, comm;
  int               index;
  Cardinal          n;
  Boolean           ok;
  
  /* Code. */

  if( getenv( "XRESOURCE_MAP_FILE" ) == NULL ){
    printf( "Error: XRESOURCE_MAP_FILE must be defined.\n" );
    printf( "Run the program with the script doDemo.\n" );
    printf( "Exiting.\n" );
    exit( 1 );
  }

  /* Enable NLS. */
#if XlibSpecificationRelease > 4
  XtSetLanguageProc( NULL, (XtLanguageProc) NULL, NULL ); 
#endif

  n = 0;
  XtSetArg( args[ n ], XmNwidth,            500 ); n++;
  XtSetArg( args[ n ], XmNheight,           500 ); n++;
  XtSetArg( args[ n ], XmNallowShellResize, False ); n++;
  
  toplevel = xmubAppInitialize( &app, APP_CLASS,
                                xmub_options, xmub_num_options,
                                (Cardinal *) &argc, argv, NULL, args, n,
                                xmub_resource_sets,
                                xmub_num_resource_sets, &mapping_ref );
  
  /* Create the widgets in the top level window. */

  /* Start with an outer form. */
  n = 0;
  form = XmCreateForm( toplevel, "topFo", args, n );  

  /* Output area. */
  n = 0;
  out_lb = XmCreateLabel( form, "outLb", args, n );

  n = 0;
  XtSetArg( args[ n ], XmNeditable, False ); n++;
  out_tx = XmCreateScrolledText( form, "outTx", args, n );

  /* Input area. */
  n = 0;
  comm = XmCreateCommand( form, "inComm", args, n );

  /* Set up callbacks for the input area. */
  XtAddCallback( comm, XmNcommandEnteredCallback,
		 (XtCallbackProc) CommandCB, (XtPointer) out_tx );
  
  /* We want this widget to have focus. */
#if XlibSpecificationRelease > 4
  n = 0;
  XtSetArg( args[ n ], XmNinitialFocus, comm ); n++;
  XtSetValues( form, args, n );
#endif

  /* Attach the widgets. */
  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetValues( out_lb, args, n );

  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        out_lb ); n++;
  XtSetArg( args[ n ], XmNtopOffset,        2 ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNbottomWidget,     comm ); n++;
  XtSetArg( args[ n ], XmNbottomOffset,     10 ); n++;
  XtSetValues( XtParent( out_tx ), args, n );

  n = 0;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_FORM ); n++;
  XtSetValues( comm, args, n );

  /* Manage the widgets. */

  XtManageChild( out_lb );
  XtManageChild( out_tx );
  XtManageChild( comm );
  XtManageChild( form );


  /* Set up the resource change callback. */
  xmubResAddSetChangedCallback( mapping_ref,
                                PrintCommand, (XtPointer) out_tx );


  
  XtRealizeWidget( toplevel );


  XtAppMainLoop( app );

}


/*----------------------------------------------------------------------*/

void
  ChangeWidgetColorsCB( Widget     widget,
                        XtPointer  dummy,
                        XtPointer  update_shadows )
{

  typedef struct {
    Pixel  foreground;
    Pixel  background;
  } ColorDefs;

  Arg        args[ 8 ];
  Pixel      bottom_shadow;
  ColorDefs  color_defs;
  Colormap   colormap;
  Cardinal   n;
  Pixel      top_shadow;

  XtResource  color_resource_list[] = {

    { XmNforeground, XmCForeground, XmRPixel, sizeof( Pixel ), 
      XtOffsetOf( ColorDefs, foreground ), XmRString, XtDefaultForeground },

    { XmNbackground, XmCBackground, XmRPixel, sizeof( Pixel ), 
      XtOffsetOf( ColorDefs, background ), XmRString, XtDefaultBackground },
  };

  /* Code. */

  /* We don't do this for gadgets, since they have no colors of their own. */
  if( ! XtIsWidget( widget ) )
    return;

  /* Impossible to deallocate old color resources.
     Eat the colormap cell waste. */

  n = 0;  
  XtSetArg( args[ n ], XmNcolormap, &colormap ); n++;
  XtGetValues( widget, args, n );

  /* Get the resources for the current widget. */
  XtGetSubresources( widget, &color_defs, NULL, NULL, color_resource_list, 
                     XtNumber( color_resource_list ), NULL, 0 );

  /* Get the shadow colors as well. */
  if( update_shadows )
    XmGetColors( XtScreenOfObject( widget ), colormap, color_defs.background,
                 NULL, &top_shadow, &bottom_shadow, NULL );

  n = 0;  
  XtSetArg( args[ n ], XmNforeground, color_defs.foreground ); n++;
  XtSetArg( args[ n ], XmNbackground, color_defs.background ); n++;

  if( update_shadows ){
    XtSetArg( args[ n ], XmNtopShadowColor,    top_shadow ); n++;
    XtSetArg( args[ n ], XmNbottomShadowColor, bottom_shadow ); n++;
  }

  XtSetValues( widget, args, n );


  return;

}


/*----------------------------------------------------------------------*/

static void
  ChangePalette( xmubResourceMappingInfoRef  ref,
                 char*                       color_set )
{

  (void) xmubResUpdateResourceSet( ref, "palette", "Palette", color_set,
                                   UpdateColors, (XtPointer) toplevel );

}


/*----------------------------------------------------------------------*/

static void 
  CommandCB( Widget                   widget,
             Widget                   text,
             XmCommandCallbackStruct  *call_data )
{

  char            *command;
  XmString        input;
  Boolean         ok;
  
  /* Code. */

  /* Temporary implementation. */
  /* Write command into output area. */
  
  /* Get command. */
  input = call_data -> value;

  if( input != NULL ){

    /* Convert to common string. */
    ok = XmStringGetLtoR( input, XmFONTLIST_DEFAULT_TAG, &command );

    if( ok ){

      /* command now contains the input string. */
      
      /* Set the entered string as the new palette. */
      ChangePalette( mapping_ref, command );
      
      /* Free the allocated string. */
      XtFree( command );

    }
  }


  return;

}


/*----------------------------------------------------------------------*/

static void
PrintCommand( xmubResourceMappingInfoRef       ref,
              XtPointer                        widget,
              xmubResSetChangeCallbackStruct*  cb )
{

  char*           line;
  XmTextPosition  pos;
  Widget          tw;
  
  /* Code. */

  tw = (Widget) widget;

  /* Insert the new palette if it was valid. */
  if( cb -> mapping_changed ){
    line = XtMalloc( strlen( cb -> res_name ) +
                     strlen( cb -> new_value ) + 20 );
    sprintf( line, "New %s is %s\n", cb -> res_name, cb -> new_value );
    
    pos = XmTextGetLastPosition( tw );
    XmTextInsert( tw, pos, line );

    /* Display the end of the newly inserted text. */
    XmTextShowPosition( tw, pos );

    XtFree( line );
    
  }
  

}


/*----------------------------------------------------------------------*/

static void
UpdateColors( xmubResourceMappingInfoRef       ref,
              XtPointer                        widget,
              xmubResSetChangeCallbackStruct*  cb )
{

  Widget  top;
  
  /* Code. */

  top = (Widget) widget;
  
  if( cb -> mapping_changed ){
    /* Update the color resources. */
    xmubIterateTree( top, (XtCallbackProc) ChangeWidgetColorsCB, 
                          (XtPointer) True );

  }
  

}

