/* Copyright 93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* 
 * tclttSession.c
 *
 *	Session related functions
 *
 * $Id: tclttSession.c,v 1.6 93/08/26 16:21:42 beust Exp $
 */

#include "main.h"

int
Tcltt_session_join(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_session_join(argv[1]);
  return result;
}

int
Tcltt_session_quit(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_session_quit(argv[1]);
  return result;
}

int
Tcltt_session_propname(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  interp -> result = tt_session_propname(argv[1], atol(argv[2]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_session_propnames_count(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_session_propnames_count(argv[1]));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_session_prop(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  interp -> result = tt_session_prop(argv[1], argv[2], atol(argv[3]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_session_prop_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  result = tt_session_prop_add(argv[1], argv[2], argv[3]);
  return result;
}

int
Tcltt_session_prop_count(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  sprintf(Tcltt_Result, "%u", tt_session_prop_count(argv[1], argv[2]));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_session_prop_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  result = tt_session_prop_set(argv[1], argv[2], argv[3]);
  return result;
}

int
Tcltt_initial_session(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(0);
  sprintf(Tcltt_Result, "%u", tt_initial_session());
  interp -> result = Tcltt_Result;
  return result;
}

