/*

Copyright 1990 by Cray Research, Inc.

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Cray Research, Inc. not be used in 
advertising or publicity pertaining to distribution of the software without
specific, written prior permission.  Cray Research, Inc. makes no 
representations about the suitability of this software for any purpose.  It 
is provided "as is" without express or implied warranty.

*/

static char vars_rcsid[]="$Id: vars.c,v 1.29 92/10/02 11:44:19 bobo Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defs.h"

extern int mail_in,mail_out;
extern char cmd_buff[];
extern mail_cmd();
extern readln();
extern char EOT_FLAG[];
extern char mail_buff[];

#define VARCSTAR	0
#define VARINT	1

char *allnet=(char *)0;
int alwaysignore;
int append;
int askcc;
int askbcc;
int asksub;
int autoprint;
int bang;
int bell;
char *cmd=(char *)0;
int cmd_box_box;
int confirm_EDITOR;
char *conversion=(char *)0;
int crt;
char *DEAD=(char *)0;
int debug;
int do_signature;
int do_xmtaliases;
int do_xmtrecord;
int dot;
char *EDITOR=(char *)0;
int edit_needs_xterm;
char *escape=(char *)0;
int flash;
char *folder=(char *)0;
int header;
int hold;
int ignore;
int ignoreeof;
int include_msg;
int interval;
int keep;
int keepsave;
char *LISTER=(char *)0;
char *MAILRC=(char *)0;
char *MBOX=(char *)0;
int metoo;
char *mprefix=(char *)0;
int num_saved_fnames;
int onehop;
int outfolder;
int page;
char *PAGER=(char *)0;
char *print_cmd=(char *)0;
char *prompt=(char *)0;
int quiet;
char *record=(char *)0;
int replyall;
int save;
int screen;
char *sendmail=(char *)0;
int sendwait;
char *SHELL=(char *)0;
int showto;
int showlast;
char *sign=(char *)0;
char *Sign=(char *)0;
int state_box;
int toplines;
int use_folders_cmd;
int verbose;
char *VISUAL=(char *)0;

struct var_ent {
	char *name;
	int type;
	long *place;
} var_table[] = {
	{"allnet",VARCSTAR,(long *)&allnet},
	{"alwaysignore",VARINT,(long *)&alwaysignore},
	{"append",VARINT,(long *)&append},
	{"askcc",VARINT,(long *)&askcc},
	{"askbcc",VARINT,(long *)&askbcc},
	{"asksub",VARINT,(long *)&asksub},
	{"autoprint",VARINT,(long *)&autoprint},
	{"bang",VARINT,(long *)&bang},
	{"bell",VARINT,(long *)&bell},
	{"cmd",VARCSTAR,(long *)&cmd},
	{"cmd_box",VARINT,(long *)&cmd_box_box},
	{"confirm_EDITOR",VARINT,(long *)&confirm_EDITOR},
	{"conversion",VARCSTAR,(long *)&conversion},
	{"crt",VARINT,(long *)&crt},
	{"DEAD",VARCSTAR,(long *)&DEAD},
	{"debug",VARINT,(long *)&debug},
	{"do_signature",VARINT,(long *)&do_signature},
	{"do_xmtaliases",VARINT,(long *)&do_xmtaliases},
	{"do_xmtrecord",VARINT,(long *)&do_xmtrecord},
	{"dot",VARINT,(long *)&dot},
	{"EDITOR",VARCSTAR,(long *)&EDITOR},
	{"edit_needs_xterm",VARINT,(long *)&edit_needs_xterm},
	{"escape",VARCSTAR,(long *)&escape},
	{"flash",VARINT,(long *)&flash},
	{"folder",VARCSTAR,(long *)&folder},
	{"header",VARINT,(long *)&header},
	{"hold",VARINT,(long *)&hold},
	{"ignore",VARINT,(long *)&ignore},
	{"ignoreeof",VARINT,(long *)&ignoreeof},
	{"include_msg",VARINT,(long *)&include_msg},
	{"interval",VARINT,(long *)&interval},
	{"indentprefix",VARCSTAR,(long *)&mprefix},
	{"keep",VARINT,(long *)&keep},
	{"keepsave",VARINT,(long *)&keepsave},
	{"LISTER",VARCSTAR,(long *)&LISTER},
	{"MAILRC",VARCSTAR,(long *)&MAILRC},
	{"MBOX",VARCSTAR,(long *)&MBOX},
	{"metoo",VARINT,(long *)&metoo},
	{"mprefix",VARCSTAR,(long *)&mprefix},
	{"num_saved_fnames",VARINT,(long *)&num_saved_fnames},
	{"onehop",VARINT,(long *)&onehop},
	{"outfolder",VARINT,(long *)&outfolder},
	{"page",VARINT,(long *)&page},
	{"PAGER",VARCSTAR,(long *)&PAGER},
	{"print_cmd",VARCSTAR,(long *)&print_cmd},
	{"prompt",VARCSTAR,(long *)&prompt},
	{"quiet",VARINT,(long *)&quiet},
	{"record",VARCSTAR,(long *)&record},
/*
 * The replyall variable should only be used if it
 * exists on the target machine.  The spelling is
 * significant.
 */
#if (BSDREPLY==2) || (BSDREPLY==4) || (BSDREPLY==7)
	{"replyall",VARINT,(long *)&replyall},
#endif
#if (BADREPLY==3) || (BSDREPLY==5) || (BSDREPLY==6)
	{"Replyall",VARINT,(long *)&replyall},
#endif
	{"save",VARINT,(long *)&save},
	{"screen",VARINT,(long *)&screen},
	{"sendmail",VARCSTAR,(long *)&sendmail},
	{"sendwait",VARINT,(long *)&sendwait},
	{"SHELL",VARCSTAR,(long *)&SHELL},
	{"showto",VARINT,(long *)&showto},
	{"showlast",VARINT,(long *)&showlast},
	{"sign",VARCSTAR,(long *)&sign},
	{"Sign",VARCSTAR,(long *)&Sign},
	{"state_box",VARINT,(long *)&state_box},
	{"toplines",VARINT,(long *)&toplines},
	{"use_folders_cmd",VARINT,(long *)&use_folders_cmd},
	{"verbose",VARINT,(long *)&verbose},
	{"VISUAL",VARCSTAR,(long *)&VISUAL}};

#define VART_LEN (sizeof(var_table)/sizeof(*var_table))

void
pr_vars()
{
int x;

for(x=0;x<VART_LEN;x++)
{
	fprintf(stderr,"%s = ",var_table[x].name);

	if(var_table[x].type==VARINT)
	{
		fprintf(stderr,"%d\n",(int)*var_table[x].place);
	}
	else
	{
		fprintf(stderr,"%s\n",(char *)*var_table[x].place);
	}
}

}
void
set_def_vars()
{

if(allnet !=0)
{
	free(allnet);
	allnet =(char *)0;
}
alwaysignore = 1;
append =0;
askcc =0;
askbcc=0;
asksub =1;
autoprint=0;
bang=0;
bell=1;

if(cmd!=0)
{
	free(cmd);
	cmd=(char *)0;
}

cmd_box_box=0;
confirm_EDITOR=1;

if(conversion!=0)
{
	free(conversion);
	conversion=(char *)0;
}

crt=0;

if(DEAD!=0)
{
	free(DEAD);
}
	if((DEAD=(char *)malloc(100))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	sprintf(DEAD,"%s/dead.letter",getenv("HOME"));

debug=0;
do_signature=1;
do_xmtaliases=1;

#ifdef USE_SENDMAIL
do_xmtrecord=1;
#else
do_xmtrecord=0;
#endif

dot=0;

if(EDITOR!=0)
{
	free(EDITOR);
}
	if((EDITOR=(char *)malloc(100))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	sprintf(EDITOR,"none");

edit_needs_xterm=1;


if(escape!=0)
{
	free(escape);
}
	if((escape=(char *)malloc(100))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	sprintf(escape,"~");


if(folder!=0)
{
	free(folder);
}
	folder=(char *)0;


header=1;
hold=0;
ignore=0;
ignoreeof=0;
include_msg=0;
interval=15;
keep=0;
keepsave=0;

if(LISTER!=0)
{
	free(LISTER);
}
	if((LISTER=(char *)malloc(100))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	sprintf(LISTER,"ls");


if(MAILRC!=0)
{
	free(MAILRC);
}
	MAILRC=(char *)malloc(100);
	sprintf(MAILRC,"%s/.mailrc",getenv("HOME"));


if(MBOX!=0)
{
	free(MBOX);
}
	MBOX=(char *)malloc(100);
	sprintf(MBOX,"%s/mbox",getenv("HOME"));

if(mprefix!=0)
{
	free(mprefix);
}
	mprefix=(char *)malloc(3);
	sprintf(mprefix,"> ");

metoo=0;
num_saved_fnames=5;
onehop=0;
outfolder=0;
page=0;



if(PAGER!=0)
{
	free(PAGER);
}
	if((PAGER=(char *)malloc(100))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	sprintf(PAGER,"more");


if(print_cmd!=0)
{
	free(print_cmd);
}
	if((print_cmd=(char *)malloc(100))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
#ifdef PRINTER_CMD
	strcpy(print_cmd,PRINTER_CMD);
#else	
	strcpy(print_cmd,"lpr -p -JMail");
#endif


if(prompt!=0)
{
	free(prompt);
}
	if((prompt=(char *)malloc(100))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	sprintf(prompt,"&");


quiet=0;

if(record!=0)
{
	free(record);
	record=(char *)0;
}

replyall=0;
save=1;
screen=0;

if(sendmail!=0)
{
	free(sendmail);
}

	if((sendmail=(char *)malloc(100))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	sprintf(sendmail,"/usr/lib/sendmail");



sendwait=0;

if(SHELL!=0)
{
	free(SHELL);
}
	if((SHELL=(char *)malloc(100))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	if(getenv("SHELL")!=NULL)
		strcpy(SHELL,getenv("SHELL"));


showto=0;
showlast=0;

if(sign!=0)
{
	free(sign);
}

	if((sign=(char *)malloc(2))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	strcpy(sign,"");



if(Sign!=0)
{
	free(Sign);
}
	if((Sign=(char *)malloc(2))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	strcpy(Sign,"");

state_box=1;
toplines=5;
use_folders_cmd=0;
verbose=0;

if(VISUAL!=0)
{
	free(VISUAL);
}
	if((VISUAL=(char *)malloc(100))==0)
	{
		fprintf(stderr,"failed to do malloc\n");
		say_good_bye();
	}
	sprintf(VISUAL,"vi");



}


void
get_vars()
{
char buff[2024],tmp_buff[2024];
char *ptr;
int var_index;

	set_def_vars();
	/*
	 * set a nonexistant variable so we know where to stop.
	 */

	sprintf(cmd_buff,"set\n");
	mail_cmd();



	for(;;)
	{
		readln(mail_out,buff,2024);


		if(strcmp(buff,EOT_FLAG)==0)
			break;



#ifdef TAB_DELIMITED
		/*
		 * SGI uses tabs to deliminate variables from thier value
		 * on printout.
		 */
		if(strlen((ptr=strchr(buff,'\t')))<=1)
#else
		if((ptr=strchr(buff,'\"'))==(char *)0)
#endif
		{

#ifdef TAB_DELIMITED
			/*
			 * the SGI has a tab after the variable if it's a toggle.
			 */
			buff[strlen(buff)-1]='\0';
#endif

			/*
			 * this variable is a toggle
			 */
			for(var_index=0;var_index<VART_LEN;var_index++)
			{
				if(strcmp(buff,var_table[var_index].name)==0)
				{
					if(var_table[var_index].type == VARINT)
						*(var_table[var_index].place)=1;
					if(var_table[var_index].type == VARCSTAR)
					{
						*(var_table[var_index].place)=(long)malloc(2);
						strcpy((char *)*(var_table[var_index].place),"");
					}

					break;
				}
				
			}
			if((var_index == VART_LEN)&&(debug))
				fprintf(stderr,"unused variable \"%s\"\n",buff);
		}
		else
		{
			/*
			 * this is a string or numeric value.
			 */
			/*diff= (long)ptr - (long)buff;*/

			


#ifdef TAB_DELIMITED
			bcopy(&ptr[1],tmp_buff,strlen(ptr));
			ptr[0]=(char)0;
#else

			/*
			 * on NON-SGI systems we have to strip the leading and trailing
			 * quote marks, and the equal sign.
			 */
			bcopy(&ptr[1],tmp_buff,strlen(ptr));
			tmp_buff[strlen(tmp_buff)-1]=0;
			ptr[-1]=(char)0;
#endif




			for(var_index=0;var_index<VART_LEN;var_index++)
			{
				if(strcmp(buff,var_table[var_index].name)==0)
				{
					if(var_table[var_index].type == VARINT)
					{
						*(var_table[var_index].place) =
							atol(tmp_buff);

						if(strspn(tmp_buff,"0123456789")==0)
						{
							/* wasn't numeric */
							if((bcmp(tmp_buff,"Yes",3)==0)||
									(bcmp(tmp_buff,"On",2)==0))
								*(var_table[var_index].place) = 1;
							else
								*(var_table[var_index].place) = 0;
						}
					}	
					else
					{
						if(*(var_table[var_index].place)
								 != 0)
							free((void *)*(var_table[var_index].place));


						*(var_table[var_index].place) =
							(long)malloc(strlen(&ptr[1])+2);

						strcpy((char *)*(var_table[var_index].place),
							tmp_buff);

					/*	bcopy(&ptr[1],
						(char *)*(var_table[var_index].place),
						strlen(ptr)-1);*/

					/*	((char *)*var_table[var_index].place)[
							strlen(ptr)-2]=0;*/
					}

					break;
				}
			}

			if((var_index == VART_LEN) && (debug))
				fprintf(stderr,"unused variable \"%s\"\n",buff);
		}
	}

	if((folder!=NULL) && (folder[0] != '/'))
	{
		ptr=folder;
		folder=(char *)malloc(strlen(ptr) + strlen(getenv("HOME"))+1);
		sprintf(folder,"%s/%s",getenv("HOME"),ptr);
		free(ptr);
	}

	if((record!=NULL) && (record[0] == '+'))
	{
		if(folder!=NULL)
		{
			ptr = record;
			record=(char *)malloc(strlen(folder) + strlen(ptr) +1);
			sprintf(record,"%s/%s",folder,&ptr[1]);
			free(ptr);
		}
		else
		{
			free(record);
			record=(char *)0;
		}
	}
	
			

	if(debug) 
		pr_vars();

	get_aliases();

}	

