/*

Copyright 1990 by Cray Research, Inc.

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Cray Research, Inc. not be used in 
advertising or publicity pertaining to distribution of the software without
specific, written prior permission.  Cray Research, Inc. makes no 
representations about the suitability of this software for any purpose.  It 
is provided "as is" without express or implied warranty.

*/

static char mail_int_rcsid[]="$Id: mail_int.c,v 1.39 92/10/02 15:18:09 bobo Exp $";

/*
 * mail interface routines.
 */
#include <stdio.h>
#include <pwd.h>
#include <sys/time.h>
#include <fcntl.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <utime.h>


#include "defs.h"

struct msg_header *header_list=(struct msg_header *)0;
struct msg_header *del_list=(struct msg_header *)0;
struct msg_header *cur_msg=(struct msg_header *)0;

extern int out_fd[2];
extern int debug;
extern Display *dpy;

extern int header_index,current_msg,num_headers,header_right,header_left;
int load_headers();


int MAIL_pid;
int in_fd[2];
int out_fd[2];
int mail_in,mail_out;

char dbox_fname[50];
char msg_fname[50];
char reply_fname[50];
char *previous_file_name=(char *)0;
char *expand_fname();

char cmd_buff[1024];

char EOT_FLAG[150];

void
mail_cmd()
{
int x;
	/*  make sure we only send one command line	*/
	for(x=0;x<strlen(cmd_buff);x++)
	{
		if(cmd_buff[x]=='\n')
		{
			cmd_buff[x+1]=0;
			break;
		}
	}

	if(write(mail_in,cmd_buff,strlen(cmd_buff))==-1)
	{
		perror("write(Mail Pipe)");
		clean_up();
		exit(1);
	}


        sprintf(cmd_buff,"version\n");

        if(write(mail_in,cmd_buff,strlen(cmd_buff))==-1)
        {
                perror("write(Mail Pipe)");
		clean_up();
                exit(1);
        }

}

int
start_mail()
{

int fd;
char first_line[150];

	if(in_fd[1]!=0)
	{
		close(in_fd[1]);
		close(out_fd[0]);
	}
	
	/*
	 * Make the names for the files used
	 *  --- In previous edditions, string Widgets
	 *  were used so much of this wasn't necesary.
	 */
	strcpy(dbox_fname,"/tmp/XMTdXXXXXX");
	mktemp(dbox_fname);
	strcpy(msg_fname,"/tmp/XMTmXXXXXX");
	mktemp(msg_fname);

	strcpy(reply_fname,"/tmp/XMTrXXXXXX");
	mktemp(reply_fname);

	/*
	 * Fill in the files that need information.
	 */
	if((fd=open(dbox_fname,O_CREAT|O_WRONLY,0600))==-1)
	{
		perror("open(dumby mbox)");
		exit(1);
	}

	if(write(fd,"\n",1)==-1)
	{
		perror("write(dumby mbox)");
		clean_up();
		exit(1);
	}

	close(fd);

	/*
	 * I start up Mail here in hopes that by the time
	 * I get down to the code below, it has gonethrough
	 * it's initilization and is ready for the version
	 * commands.
	 */
	if(pipe(in_fd)==-1)
	{
		perror("pipe(input)");
		clean_up();
		exit(1);
	}

	if(pipe(out_fd)==-1)
	{
		perror("pipe(output)");
		clean_up();
		exit(1);
	}
	
	if((MAIL_pid=fork())==0)
	{
		close(in_fd[1]);
		close(out_fd[0]);
		
		dup2(in_fd[0],0);
		dup2(out_fd[1],1);
		dup2(out_fd[1],2);
		close(in_fd[0]);
		close(out_fd[1]);
                execlp(MREADER,MREADER,"-N",
                                        "-f",dbox_fname,0);
		perror("execlp");
		exit(1);
	}

	if(MAIL_pid==-1)
	{
		perror("fork(Mail proccess)");	
		clean_up();
		exit(1);
	}

	close(in_fd[0]);
	close(out_fd[1]);
	mail_in = in_fd[1];
	mail_out= out_fd[0];

	if((fd=open(msg_fname,O_CREAT|O_WRONLY,0600))==-1)
	{
		perror("open(message file)");
		clean_up();
		exit(1);
	}

	if(write(fd,"You Should never see this message.\n",35)==-1)
	{
		perror("write(message file)");
		clean_up();
		exit(1);
	}

	close(fd);

	if((fd=open(reply_fname,O_CREAT|O_WRONLY,0600))==-1)
	{
		perror("open(reply file)");
		clean_up();
		exit(1);
	}

	if(write(fd,"You Should never see this message.\n",35)==-1)
	{
		perror("write(reply file)");
		clean_up();
		exit(1);
	}

	close(fd);



        sprintf(cmd_buff,"version\nversion\n");
        if(write(mail_in,cmd_buff,strlen(cmd_buff))==-1)
        {
                perror("write(Mail Pipe)");
		clean_up();
                exit(1);
        }

	if(readln(mail_out,first_line,150)==-1)
	{
		perror("readln");
		clean_up();
		exit(1);
	}

	for(;;)
	{
		/*
		 * Read additional lines until we get two that
		 * match.  This should be the EOT_FLAG we want.
		 */
		if(readln(mail_out,EOT_FLAG,150)==-1)
		{
			perror("readln");
			clean_up();
			exit(1);
		}

		if(strcmp(first_line,EOT_FLAG)==0)
		{
			/*
			 * I'm assuming that it will
			 * be the EOT_FLAG.
			 */
			break;
		}
		{
			/*
			 * didn't get version string
			 */
			strcpy(first_line,EOT_FLAG);
		}
	}

	return(0);
}

void
park_mail()
{
	char *ptr;
	extern char dbox_fname[];

/*  the idea here is to park the car
    in a safe place   */

	chg_file(dbox_fname,&ptr);
	warn(ptr);
}

void
pr_msg_list()
{
struct msg_header *m;

	for(m=header_list;m!=(struct msg_header *)0;m=m->next)
	{
		fprintf(stderr,"message #%d = %x\n",m->num,m);
		fprintf(stderr,"from => %s\n",m->data);
		fprintf(stderr,"next = %x\n",m->next);
		fprintf(stderr,"prev = %x\n",m->prev);
	}
	fprintf(stderr,"del_list:\n");
	for(m=del_list;m!=(struct msg_header *)0;m=m->next)
	{
		fprintf(stderr,"message #%d = %x\n",m->num,m);
		fprintf(stderr,"next = %x\n",m->next);
		fprintf(stderr,"prev = %x\n",m->prev);
	}
}

static char *header_data=(char *)0;

/*
 * this function creates a buffer containing the pertanent text
 * out the headers.  It also calls load__headers which requires num_headers
 * to be set to the number of headers in mailbox.
 */
int
get_headers(load,ptr)
int load;
char **ptr;
{
register int header_data_index;
int num_char,res;
register struct msg_header *m;

/*	if(header_data!=(char *)0)
		free(header_data); */

	if(header_data==(char *)0)
		header_data=(char *)malloc(250);


	if(num_headers==0)
	{
		/*
		 * there are no headers to be gotten.
		 */
		header_right=0;
		header_left=0;
		header_list=0;
		*ptr="";
		return(0);
	}
		

	if(load==1)
	{
		if((res=load_headers())==-1)
		{
			/*
			 * loading the headers failed for some reason.
			 * this appears to be a fatal error.
			 */
			fprintf(stderr,"Fatal error on Load headers\n");
			say_good_bye();
		}
		if(res!=num_headers)
		{
			fprintf(stderr,"Couldn't load all of the headers\n");
			say_good_bye();
		}
	}

	/*
	 * We now know that there are headers to be gotten, We were able
	 * to load them.  If header_list is NULL then there is something
	 * wrong.  If we didn't load them we have to make sure that header
	 * list isn't empty.
	 */
	if(header_list == (struct msg_header *)0)
	{
		header_right=0;
		header_left = 0;
		*ptr="";
		return(0);
	}

	header_data_index=0;

	for(m = header_list; m != (struct msg_header *)0; m = m->next)
	{
		if(m == cur_msg)
			m->cur='>';
		else
			m->cur=' ';

		header_data=(char *)realloc(header_data,header_data_index+250);
		sprintf(&header_data[header_data_index],
					"%c%c%3d %s\n", m->cur, 
				m->stat, m->num, m->data);

		num_char=strlen(&header_data[header_data_index]);
		if(m == cur_msg )
		{
			header_right = header_data_index + num_char;
			header_left = header_data_index;
		}

		header_data_index += num_char;

	
	}
	header_data[header_data_index-1]=(char)0;
	*ptr=header_data;
	return(num_headers);
}

line_to_header(d,m)
char d[];		/* data string	*/
register struct msg_header *m;
{
char *str;
int num_start;

	m->cur=d[0];
	if((m->cur!=' ')&&(m->cur!='>'))
	{
		fprintf(stderr,"line_to_header():::header data out of synch\n");
		fprintf(stderr,"line == %s\n",d);
		say_good_bye();
	}
	m->stat=d[1];

	num_start=strspn(&d[2]," \t");
	m->num=(int)atol(&d[2+num_start]);
	if((m->num<=0)||(m->num>num_headers))
	{
		fprintf(stderr,"line_to_header():::header data out of synch\n");
		fprintf(stderr,"line == %s\n",d);
		say_good_bye();
	}

	str=strchr(&d[2+num_start],(int)' ');

	strcpy(m->data,&str[1]);

}
	

void
free_headers()
{
	register struct msg_header *tmp_header,*this_header;
	
	
	this_header=header_list;

	for(;this_header!=(struct msg_header *)0;)
	{
		tmp_header=this_header->next;
		free(this_header);
		this_header=tmp_header;
	}

	header_list=(struct msg_header *)0;

	this_header=del_list;

	for(;this_header!=(struct msg_header *)0;)
	{
		tmp_header=this_header->next;
		free(this_header);
		this_header=tmp_header;
	}

	del_list=(struct msg_header *)0;
}	


	

int
load_headers()
{
	char header_line_data[200];
	struct msg_header *tmp_header,*this_header;
	int cur_msg_num;
	extern long showlast;	

	free_headers();

	if(num_headers == 0)
		return(0);


	if(showlast)
		strcpy(cmd_buff,"from $\n");
	else
		strcpy(cmd_buff,"from .\n");

	mail_cmd();

	if(readln(mail_out,header_line_data,190)==-1)
	{
			perror("Can't read Mail Pipe");
			warn("Can't read Mail Pipe");
			XBell (dpy, 10);
			XFlush(dpy);
			return(-1);
	}
	sscanf(&header_line_data[2]," %d",&cur_msg_num);
	for(;;)
	{
		if(readln(mail_out,header_line_data,190)==-1)
		{
			perror("Can't read Mail Pipe");
			warn("Can't read Mail Pipe");
			XBell (dpy, 10);
			XFlush(dpy);
			return(-1);
		}
		if(strcmp(header_line_data,EOT_FLAG)==0)
			 break;
	}

	strcpy(cmd_buff,"from ^-$\n");
	mail_cmd();


	this_header=0;
	for(header_index=0; ;header_index++)
	{
		if(readln(mail_out,header_line_data,190)==-1)
		{
			perror("Can't read Mail Pipe");
			warn("Can't read Mail Pipe");
			XBell (dpy, 10);
			XFlush(dpy);
			return(-1);
		}


		if(strcmp(header_line_data,EOT_FLAG)==0)
			break;

		if(this_header==(struct msg_header *)0)
		{
			this_header=(struct msg_header *)malloc(
					sizeof(struct msg_header));
			this_header->prev=(struct msg_header *)0;
			this_header->next=(struct msg_header *)0;
			tmp_header=this_header;
			header_list=this_header;
		}
		else
		{
			tmp_header=(struct msg_header *)malloc(
					sizeof(struct msg_header));
			tmp_header->prev=this_header;
			this_header->next=tmp_header;
			tmp_header->next=(struct msg_header *)0;
			this_header=tmp_header;
		}

			
		line_to_header(header_line_data,this_header);
		
		if(this_header->num==cur_msg_num)
		{
			cur_msg=this_header;
			cur_msg->cur='>';
			
		}
		else
		{
			this_header->cur=' ';
		}

	}
	return(header_index);
}

struct msg_header
*get_num_msg(msg)
int msg;
{
	struct msg_header *this_header;
	if(header_list==0)
	{
		return(NULL);
	}	
	for(this_header=header_list; this_header!=(struct msg_header *)0;
				this_header=this_header->next)
	{
		if(this_header->num == msg)
			return(this_header);
	}

	return(NULL);
}


show_msg(msg)
int msg;
{

	struct msg_header *this_header;
	if(header_list==0)
	{
		display_msg(NULL);
		return;
	}

	this_header= get_num_msg(msg);	

	if(this_header == (struct msg_header *)0)
		return;

	display_msg(this_header);

	
}
/*
 * delete current message.
 */
delete_msg()
{
struct msg_header *tmp_msg;
	
	if(cur_msg==(struct msg_header *)0)
		return;

	if(cur_msg->next != (struct msg_header *)0)
		(cur_msg->next)->prev = cur_msg->prev;

	if(cur_msg->prev != (struct msg_header *)0)
		(cur_msg->prev)->next = cur_msg->next;
	else
		header_list = cur_msg->next;


	if(cur_msg->next == (struct msg_header *)0)
	{
		tmp_msg= cur_msg->prev;
	}
	else
	{
		tmp_msg= cur_msg->next;
	}

	cur_msg->next = del_list;
	del_list = cur_msg;

	sprintf(cmd_buff,"delete %d\n",cur_msg->num);
	mail_cmd();
	read_rest(mail_out);
/*	cur_msg= tmp_msg; */

	display_msg(tmp_msg);
}
	
/*
 * undelet the last deleted message.
 * it still points to the message that proceded it in the list.
 */
undelete_msg()
{
struct msg_header *tmp_msg;

	if(del_list == (struct msg_header *)0)
		return;

	cur_msg=del_list;
	del_list=cur_msg->next;
	tmp_msg=cur_msg->prev;

	/*
	 * if this was the top message, then repoint the header list
	 * pointer.
	 */
	if(tmp_msg == (struct msg_header *)0)
	{
		if(header_list == (struct msg_header *)0)
		{
			header_list=cur_msg;
			cur_msg->next= (struct msg_header *)0;
		}
		else
		{
			header_list->prev = cur_msg;
			cur_msg->next = header_list;
			header_list = cur_msg;
		}
	}
	/*
	 * otherwise put it back into the list.
	 */
	else
	{
		cur_msg->next = tmp_msg->next;
		/*
		 * cur_msg->prev is already set.  That's how we got here.
		 */
		tmp_msg->next = cur_msg;

		if(cur_msg->next != (struct msg_header *)0)
			(cur_msg->next)->prev = cur_msg;
	}

	sprintf(cmd_buff,"undelete %d\n",cur_msg->num);
	mail_cmd();
	read_rest(mail_out);

	show_msg(cur_msg->num);

}

/*
 * go to previous message
 */
prev_msg()
{
	
	if(cur_msg==(struct msg_header *)0)
		return;
	if(cur_msg->prev != (struct msg_header *)0) {
		cur_msg = cur_msg->prev;
	} else if(cur_msg->next != (struct msg_header *)0) {
		cur_msg = cur_msg->next;
	} else {
		return;
	}
	

	show_msg(cur_msg->num);
}

/*
 * go to next message
 */
void
next_msg()
{
	
	if(cur_msg==(struct msg_header *)0)
		return;
	if(cur_msg->next != (struct msg_header *)0) {
		cur_msg = cur_msg->next;
	} else if(cur_msg->prev != (struct msg_header *)0) {
		cur_msg = cur_msg->prev;
	} else {
		return;
	}
	

	show_msg(cur_msg->num);
}

/*
 * save current message and change its status.
 */
int
save_msg(fn,cmd)
char *fn,*cmd;
{
char tmp_buff[1024];

	if(cur_msg == (struct msg_header *)0)
		return(-1);
	if(strlen(fn)==0)
		sprintf(cmd_buff,"%s %d\n",(cmd==0?"save":cmd),
				cur_msg->num);
	else
		sprintf(cmd_buff,"%s %d %s\n",(cmd==0?"save":cmd),
				cur_msg->num,fn);
	mail_cmd();

	get_info(mail_out,tmp_buff,1024);
	warn(tmp_buff);
	if((strstr(tmp_buff,"No such file")!=NULL) ||
			(strstr(tmp_buff,"a directory")!=NULL) ||
			(strstr(tmp_buff,"Permission denied")!=NULL))
	{
		sprintf(cmd_buff,"preserve %d\n",cur_msg->num);
		mail_cmd();
		get_info(mail_out,tmp_buff,1024);
		XBell (dpy, 10);
		XFlush(dpy);
		return(-1);
	}
	else
	{
		cur_msg->stat='*';
		add_saved_file(fn);
		return(0);
	}


}



/*
 * change current file.  Return message line if sucessfull.
 */
int
chg_file(n,s)
char *n;	/* file name	*/
char *s[];	/* place to put message	*/
{
extern Widget folder_name_item;
char *ptr;
char buff[200];
static char lbuff[1024];
static Arg arglist[]={{XtNlabel,(XtArgVal) 0}};
extern char *system_mbox_fname,*resource_mbox_fname;
int tmp_num_headers=(-1);
struct utimbuf times;

	*s=lbuff;

	warn("Loading messages.  -- Please Wait --");

	if(strcmp(n,"%")==0)
		arglist[0].value=(XtArgVal) "System Mail Box";
	else
		arglist[0].value=(XtArgVal) n;

	
	if((strcmp(n,"%")==0) && (resource_mbox_fname!=(char *)0))
		sprintf(cmd_buff,"file %s\n",system_mbox_fname);
	else
		sprintf(cmd_buff,"file %s\n",n);
	mail_cmd();

	/*
	 * we are looking for a line that contains a colon (:) or that
	 * says something about no mail.
	 * Error messages from Mail(1) may be in the form
	 *  file_name: message
	 * So... We need to look beyond error messages to find a
	 * message with a header count in it
	 */
	strcpy(lbuff,"");

	for(;;)
	{
		ptr=(char *)0;
		if(readln(mail_out,buff,190)==-1)
		{
			perror("Can't read Mail Pipe");
			warn("Can't read Mail Pipe");
			XBell (dpy, 10);
			XFlush(dpy);
			strcpy(lbuff,"Can't read Mail Pipe");
			return(-1);
		}
		if(strcmp(buff,EOT_FLAG)==0)
			break;

		strcat(lbuff,buff);
		strcat(lbuff,"\n");

		/*
		 * the message that indicates that the file doesn't
		 * exist or is empty doesn't start with a quotation mark.
		 */
		if(strncmp("No mail for",buff,7)==0)
			tmp_num_headers=0;

		if((ptr=strchr(buff,':'))!=(char *)0)
		{
	/*
	 * the next thing after the colon is the number of headers.
	 * This next line looks for the first character after the colon
	 * that isn't a white space and then checks that the thing after
	 * that is numeric.
	 */
			if(strspn(&ptr[1+strspn(&ptr[1]," \t")],
							"0123456789")!=0)
			{
				tmp_num_headers=atol(&ptr[1+strspn(&ptr[1],
								" \t")]);
				XtSetValues(folder_name_item,arglist,1);
				add_saved_file(n);
			}
		}
	}

	if(tmp_num_headers==-1)
	{

		/*
		 * if we can't change file, then the old
		 * messages are valid.
		 */
		return(-1);
	}
	else
	{
		num_headers=tmp_num_headers;

		if(previous_file_name!=(char *)0)
		{
			times.modtime=time((time_t *)0);
			times.actime=times.modtime+1;
			(void)utime(previous_file_name,&times);
			free(previous_file_name);
		}

		if((strcmp(n,"%")==0) && (resource_mbox_fname!=(char *)0))
			previous_file_name = expand_fname(system_mbox_fname);
		else if(strcmp(n,"%") != 0)
			previous_file_name=expand_fname(n);
		else
#ifdef __clipper__
			previous_file_name=expand_fname(system_mbox_fname);
#else
			previous_file_name=(char *)0;
#endif

		return(0);
	}
}

record_outbound(f)
char *f;
{
int fd,nread;
FILE *rec_file;
struct passwd *mypwent;
char line_buff[1024];
time_t my_time;
extern char *record;

	if(record==(char *)0)
		return;

	if((rec_file=fopen(record,"a"))==NULL)
	{
		perror(record);
		return;
	}

	if((mypwent=getpwuid(getuid()))==(struct passwd *)0)
	{
		perror("getpwuid()");
		return;
	}

	if((fd=open(f,O_RDONLY))==-1)
	{
		perror(f);
		fclose(rec_file);
		return;
	}

	my_time=time((time_t *)0);
	fprintf(rec_file,"\n\nFrom %s %s",mypwent->pw_name,ctime(&my_time));
	fflush(rec_file);

	for(;;)
	{
		nread=read(fd,line_buff,1024);
		if(nread<1)
			break;
		write(fileno(rec_file),line_buff,nread);
	}

	close(fd);
	fclose(rec_file);
	return;
}

int
send_reply(f)
char *f;
{
int fd,reply_pid;
extern char *sendmail,*SHELL;
extern int do_xmtaliases,do_xmtrecord;

	if(do_xmtaliases)
	{
		exp_addrs(f);
	}

	if(do_xmtrecord)
	{
		record_outbound(f);
	}

	if((fd=open(f,O_RDONLY))==-1)
	{
		warn("couldn't open message file");
			XBell (dpy, 10);
			XFlush(dpy);
		return(0);
	}


	if((reply_pid=fork())==0)
	{
		close(0);
		dup(fd);
		if(strcmp(sendmail,"/usr/lib/sendmail")==0)
		{
#ifdef USE_SENDMAIL
			execlp("/usr/lib/sendmail","sendmail","-t",0);
#else
			execlp(MREADER,MREADER,"-t",0);
#endif

		}
		else
		{
			execlp(SHELL,SHELL,"-c",sendmail);
		}
		XBell (dpy, 10);
		XFlush(dpy);
	}

	if(reply_pid==-1)
	{
		warn("Couldn't fork() process for sendmail().\n");
			XBell (dpy, 10);
			XFlush(dpy);
		return(-1);
	}

	close(fd);
	return(0);

}

void
preserve_msg()
{
	
char tmp_buff[1024];

	if(cur_msg == (struct msg_header *)0)
		return;

	sprintf(cmd_buff,"preserve %d\n",cur_msg->num);
	mail_cmd();

	get_info(mail_out,tmp_buff,1024);
	warn(tmp_buff);
	cur_msg->stat='P';

}
