.TH libtamil 3 "3 Sep 1993" "Version 0.5"
.SH NAME
libtamil \- a Tamil library of functions for X windows
.SH SYNOPSIS
.ft B
.nf
#include <tamil.h>
.LP
void fp_madurai2tamil (ifp, ofp)
FILE* ifp;
FILE* ofp;
.LP
void fn_madurai2tamil (ifile, ofile)
char* ifile;
char* ofile;
.LP
int buf_madurai2tamil (buf, sz, op)
unsigned char* buf;
int sz;
FILE* op;
.LP
String str_madurai2tamil (string, can_delete)
String string;
int can_delete;
.LP
void fp_tamil2madurai (ifp, ofp)
FILE* ifp;
FILE* ofp;
.LP
void fn_tamil2madurai (ifile, ofile)
char* ifile;
char* ofile;
.LP
int buf_tamil2madurai (buf, sz, op)
unsigned char* buf;
int sz;
FILE* op;
.LP
String str_tamil2madurai (string, can_delete)
String string;
int can_delete;
.LP
void fp_tamil2ps (ifp, ofp)
FILE* ifp;
FILE* ofp;
.ft R
.fi
.SH DESCRIPTION
The functions in
.I libtamil
can be used to convert an Xaw ASCII application into a Tamil application.
.LP
.B fp_madurai2tamil(\|)
converts any transliterated Madurai English between the Madurai
delimiters \\bt and \\et in the input file pointer to by the
file pointer
.I ifp
to Tamil characters and saves the entire translated file in the output
file pointer to by the file pointer
.I ofp.
If
.I ifp
is 0, then
.I stdin
is assumed. Similarly, if
.I ofp
is 0, then
.I stdout
is assumed.
.LP
.B fn_madurai2tamil(\|)
converts any transliterated Madurai English between the Madurai
delimiters \\bt and \\et in the input file
.I ifile
to Tamil characters and saves the entire translated file in the output
file
.I ofile.
If
.I ifile
is 0, then
.I stdin
is assumed. Similarly, if
.I ofile
is 0, then
.I stdout
is assumed.
.LP
.B buf_madurai2tamil(\|)
converts any transliterated Madurai English between
the Madurai delimiters \\bt and \\et in the
.I sz
characters in
.I buf
to Tamil characters and saves the entire translated string in the file
pointed to by the file pointer
.I op.
If
.I op
is 0, then
.I stdout
is assumed. It is an error for
.I buf
to be 0 and
.I sz
to be less than 0. It returns 0, if the translation is a success
else it returns -1.
.LP
.B str_madurai2tamil(\|)
converts any transliterated Madurai English between
the Madurai delimiters \\bt and \\et in
.I string
and returns the new translated string. If
.I can_delete
is not 0, then input
.I string
is freed using
.I XtFree(\|).
.LP
.B fp_tamil2madurai(\|)
converts the Tamil characters in the input file pointer
to by the file pointer
.I ifp
to Madurai transliterated English and saves the
translated file in the output file pointer to by the file
pointer
.I ofp.
If
.I ifp
is 0, then
.I stdin
is assumed. Similarly, if
.I ofp
is 0, then
.I stdout
is assumed.
.LP
.B fn_tamil2madurai(\|)
converts the Tamil characters in the input file
.I ifile
to Madurai transliterated English and saves the
translated file in the output file
.I ofile.
If
.I ifile
is 0, then
.I stdin
is assumed. Similarly, if
.I ofile
is 0, then
.I stdout
is assumed.
.LP
.B buf_tamil2madurai(\|)
converts the Tamil characters in the
.I sz
characters in
.I buf
to Madurai transliterated English and saves the entire
translated string in the file pointed to by the file
pointer
.I op.
If
.I op
is 0, then
.I stdout
is assumed. It is an error for
.I buf
to be 0 and
.I sz
to be less than 0. It returns 0, if the translation is a success
else it returns -1.
.LP
.B str_tamil2madurai(\|)
converts the Tamil characters in
.I string
into Madurai transliterated English and returns the new
translated string. If
.I can_delete
is not 0, then input
.I string
is freed using
.I XtFree(\|).
.LP
.B fp_tamil2ps(\|) 
converts the input file pointed to by the file pointer
.I ifp
to PostScript and saves the PostScript in the output file
pointed to by the file pointer
.I ofp.
If
.I ifp
or
.I ofp
are 0, then it does nothing.
.SH SEE ALSO
(none)
.SH COPYRIGHT
(C) 1993 Gnanasekaran Swaminathan

Permission is granted to distribute
.B libtamil
in source and binary forms at your own risk as long
as the above copyright notice and this permission notice
are also included in your distribution.

Copyright of AsciiSrc.c is governed by the Copyright 
and the Permission Notice given there.
.SH ACKNOWLEDGEMENT
.LP
Madurai transliteration scheme was invented by
Bala Swaminathan <bala@wucs1.wustl.edu>
.LP
AsciiSrc.c is taken from X11R5 distribution. It was
written by Chris Peterson of MIT X Consortium.
.LP
Following people reported bugs in
.B libtamil
and thus, helped improve the library:
.in +.5i
.nf
Badrinarayanan Seshadri <badri@sofia.tn.cornell.edu>
Ravi Sundaram <sundaram@me.uta.edu>
S Kesavan <kesavans@skinner.cs.uoregon.edu>
.fi
.in
.LP
PostScript is a registered trade mark of Adobe Systems, Inc.
.SH BUG REPORTS
Send all the bug reports to the author Gnanasekaran Swaminathan
<gs4t@virginia.edu>.
