/* Copyright (C) 1994 Groupe BULL. See file COPYRIGHT for details */
/*
 *
 * $Id: kts_queue.c,v 1.1 1994/10/07 16:34:43 beust Exp beust $
 */

#include "kts_main.h"

static void
freeQueuedMessageRec(Kts_QueuedMessage qm)
{
   
}

void
kts_queueInit(GV gv)
{
   gv -> queuedMessages =
      DB_NewDataBase(sizeof(Kts_QueuedMessageRec), freeQueuedMessageRec);
   
}

void
kts_queueStoreMessage(GV gv, char *krl, Kt_Message msg)
{
   Kts_QueuedMessage qm;

   NEW(qm, Kts_QueuedMessageRec);
   qm -> krl = kt_strdup(krl);
   qm -> msg = kt_MessageCopy(msg);
   DB_AddEntry(gv -> queuedMessages, qm);
}

void
kts_queueSendMessages(GV gv, char *krs, IceConn iceConn, CARD32 krSpecId)
{
   DataBase db = gv -> queuedMessages;
   Kts_QueuedMessage qm;

   if (0 == strlen(krs)) return;

   DB_Rewind(db);
   while (! DB_EndOfDataBase(db)) {
      qm = DB_NextEntry(db);
      if (True == kt_regexpMatch(krs, qm -> krl)) {
	 kts_forwardMessage(gv, iceConn, qm -> msg, krSpecId);
/*@@
	 DB_RemoveEntry(db, qm);
*/
      }
   }
}
