/* Copyright (C) 1994 Groupe BULL. See file COPYRIGHT for details */
/*
 *
 * $Id: kts_main.h,v 1.1 1994/10/07 16:34:43 beust Exp beust $
 */

#ifndef __KTS_MAIN_H__
#define __KTS_MAIN_H__

#define KTS_VERSION "1.1beta"


#include <assert.h>


#include "kt_typesP.h"
#include "kt_lib.h"

#include "database.h"

/* Definition of what a declared KRL is */
typedef struct {
   char *krlName;     /* name of the krl */
   CARD32 krlId;      /* the id the client will be using to refer to it */
} Kts_DeclaredKRLRec, *Kts_DeclaredKRL;

/* Definition of what an observed/handled Koalatalk resource is */
typedef struct {
   char *krSpec;    /* the kr specification */
   CARD32 krSpecId;   /* id the send expects to receive */
} Kts_InterestedInKRRec, *Kts_InterestedInKR;

/*
** Definition of a connection for one client
** isVirtual : True if this is not an actual connection but comes from protocols
** declaredKRL:  database of Kts_DeclaredKRL
** interestedInKR: database of Kts_InterestedInKR
** The virtual part is meaningful *only* if (isVirtual == True)
*/
typedef struct {
                                int fd;
                                char *iceSenderCoord;
				IceConn iceConn;
				DataBase declaredKRL; 
				DataBase interestedInKR;
                                Bool isVirtual;
                                Kt_messageBuffer msgSendOnExit;
                                CARD32 msgSendOnExitKRLId;
                                struct {
				   char *executable;
				   char *krs;
				   Bool isObserved;
				} virtual;
} Kts_ConnectionRec, *Kts_Connection;


/*
** This is used to store messages that couldn't be delivered immediately
** and that are waiting for a client to appear
*/
typedef struct {
                                 Kt_Message msg;
				 char *krl;
} Kts_QueuedMessageRec, *Kts_QueuedMessage;

/*
** To hold global variables
** connections: database of Kts_Connection
** handlers: database of Kt_handler (kt_typesP.h)
** protocols : database of Kts_Protocol
*/
typedef struct _GlobalVars {
                              int debugLevel;
			      DataBase connections;
			      DataBase handlers;
			      DataBase queuedMessages;
			      jmp_buf errorEnv;
			      int serial;
			      int mainProtocol;
			      int mainFd;
                              int rpcFd;
                              fd_set defaultFdSet;
			      IceListenObj mainListenObj;
} GlobalVarsRec, *GV;

extern GV GlobalVars;

/*
** kts_process.c
*/

void
kts_processMessage(IceConn iconn, void *clientData,
		   int opCode, unsigned long length, Bool swap);

/*
** kts_dispatch.c
*/

void
kts_dispatchMessage(GV gv, Kt_messageBuffer mb, CARD32 dest, int fd);


void
kts_broadcastNewHandler(GV gv, char *krSpec, int senderFd,
			CARD32 krSpecId, char *iceCoord);

/*
** kts_main.c
*/

IceListenObj
kts_nonLocalListenObj(int count, IceListenObj *obj);

void
kts_addRealClient(GV gv, IceConn iceConn);

void
kts_addVirtualClient(GV gv, char *executable, char *krs, Bool isObserved);

void
kts_removeRealClient(GV gv, int fd);

void
kts_declareKRL(GV gv, CARD32 krlId, char *krlName, int fd);

void
kts_observeKR(GV gv, char *krSpec, CARD32 krSpecId, int fd);

void
kts_forwardMessageBuffer(GV gv, Kts_Connection clientTo, Kt_messageBuffer mb,
		      CARD32 krSpecId, Kts_Connection clientFrom);

void
kts_forwardMessage(GV gv, IceConn iceConn, Kt_Message msg,
		   CARD32 krSpecId);


/*
** kts_protocol.c
*/

void
kts_readProtocolFiles(GV gv);

void
kts_displayProtocols(GV gv);

/*
** Return True if a client that understands this operation is found
** in our protocol list. In that case, ktserv will store the incoming
** message for later use. Otherwise, it will be silently discarded.
** isObserved is True if the matching client must observe the pattern,
** False if it must handle it.
*/
Bool
kts_checkVirtualClients(GV gv, char *krlName, Bool isObserved);

/*
** kts_queue.c
*/
/*
**---------------------------------------------------------------------------
** kts_queueInit
** Initialize the place where we will store the pending messages
*/
void
kts_queueInit(GV gv);

/*
**---------------------------------------------------------------------------
** kts_queueStoreMessage
** A message was received but has no recipients yet. A matching protocol
** could be found. This function stores the message in a queue so that
** it gets eventually sent when the appropriate client is launched and
** connects to ktserv
*/
void
kts_queueStoreMessage(GV gv, char *krl, Kt_Message msg);

/*
**---------------------------------------------------------------------------
** kts_queueSendMessages
** A new client has just connected and was launched automatically by
** myself. Send immediately all the pending messages to it
*/
void
kts_queueSendMessages(GV gv, char *krs, IceConn iceConn, CARD32 krSpecId);

/* kts_advertise.c */

/*
**---------------------------------------------------------------------------
** kts_advertiseMyPresence
** Store my coordinates in well-known places so that kt_LocateServer()
** can find me.
*/
void
kts_advertiseMyPresence(GV gv, int count, IceListenObj *obj);


#endif /* __KTS_MAIN_H__ */
