/* Copyright (C) 1994 Groupe BULL. See file COPYRIGHT for details */
/*
 *
 * $Id: kts_advertise.c,v 1.4 1994/12/14 10:38:27 beust Exp $
 */

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <stdlib.h>    /* getenv() */
#include "kts_main.h"
#include "kt_typesP.h"

/***********************************************************************
 * Private
 **********************************************************************/

static char *ServerLocation;

#ifndef NO_RPC
/*
** Mustn't be static since kts_main.c refers to it
*/

static bool_t
kts_xdrStringEncode(XDR *xdrs, char **string)
{
   bool_t result;
   result = xdr_string(xdrs, string, 128);
   return result;
}

void
kts_rpcDispatch(struct svc_req *request, SVCXPRT *xprt)
{
   unsigned int data = 42;
   switch(request -> rq_proc) {
      case NULLPROC : {
	 (void) svc_sendreply(xprt, xdr_void, 0);
	 break;
      }
      case GETPORT : {
	 svc_sendreply(xprt, kts_xdrStringEncode, & ServerLocation);
	 break;
      }
      default : {
	 printf("kts_rpcDispatch : unknown dispatched procedure : %d\n", request -> rq_proc);    
      }
   }
}

static void
kts_rpcRegisterPortmap(GV gv, char *host)
{
   int result;
   int rpcFd;
   SVCXPRT *xprt;
   pmap_unset(KTS_PROG_NUM, KTS_VERS_NUM);
   xprt = svctcp_create(RPC_ANYSOCK, 0, 0);
   if (NULL == xprt)
      printf("svctcp_create failed\n");
   else {
      if (FALSE==svc_register(xprt, KTS_PROG_NUM, KTS_VERS_NUM,
			      kts_rpcDispatch, IPPROTO_TCP))
	 printf("*** portmapper warning : can't register ktserv\n");
      for (rpcFd = 0; rpcFd < kt_getdtablesize(); rpcFd++)
	 if (FD_ISSET(rpcFd, & svc_fdset)) break;
      gv -> rpcFd = xprt -> xp_sock;
   }
/*
   svc_run();
*/
#if 0
      while (1) {
	 int fd;
	 fd_set set = svc_fdset;
	 fd = select(kt_getdtablesize(), & set, 0, 0, 0);
	 switch(fd) {
	    case -1 :
	       perror("select failed\n"); return;
	    case 0 :
	       printf("0\n"); continue;
	    default:
	       svc_getreqset(& set);
	 }
      }
#endif
}

/*
** Register the ktserv service to the portmapper
** Side effect : affect gv -> defaultFdSet to svc_fdset
*/
static void
kts_storeCoordinatesOnPortmapper(GV gv, unsigned int port)
{
   char hostname[128];
   gethostname(hostname, 128);
   kts_rpcRegisterPortmap(gv, hostname);
}

#endif /* NO_RPC */

/*
** Store coordinates on the display
*/
static void
kts_storeCoordinatesOnDisplay(GV gv, char *iceCoord, char *displayName)
{
/* For the properties */
  Atom atom, atomReturn;
  int formatReturn;
  unsigned long n, bytes;
  unsigned char *result;
  char *p;
  int success;
  Window win;
  Display *display;

/* Open the display */
  display = XOpenDisplay(displayName);
  if (! display) {
    fprintf(stderr, "server couldn't open display '%s'\n", displayName);
    exit(0);
  }

/* Create a window that will contain the properties */

  win = XCreateSimpleWindow(display, DefaultRootWindow(display),
			    0,0,1,1,0,0,0);

  if (! win) {
    fprintf(stderr, "ktserver couldn't open simple window\n");
    exit(-3);
  }

/* Write the window number to the root window */
  XChangeProperty(display,
		  DefaultRootWindow(display),
		  atom = XInternAtom(display, PROPERTY_WINDOW, False),
		  XA_INTEGER,              /* type */
		  32,        /* format (bits) */
		  PropModeReplace,
		  (unsigned char*) & win,
		  1
		  );

/* Write the coordinates */
  XChangeProperty(display,
		  win,
		  atom = XInternAtom(display, PROPERTY_KTSERV_COORD, False),
		  XA_STRING,     /* type */
		  8,            /* format (bits) */
		  PropModeReplace,
		  (unsigned char *) iceCoord,
		  strlen(iceCoord)
		  );

  XFlush(display);
  XChangeProperty(display,
		  win,
		  atom = XInternAtom(display, PROPERTY_KTSERV_COORD, False),
		  XA_STRING,     /* type */
		  8,            /* format (bits) */
		  PropModeReplace,
		  (unsigned char *) iceCoord,
		  strlen(iceCoord)
		  );

  XFlush(display);

}

/*
** Store our port number in FILE_KTSERV_PORT and pid in FILE_KTSERV_PID
*/
static void
kts_storeCoordinatesOnFile(GV gv, char *iceCoord)
{
   char format[64], *p = iceCoord;
   int port = 0;


   /*
   ** Store coordinates in file
   */
   while (*p && *p != ':') p++;
   if (*p) p++;
   while (*p) {
      port = (port * 10) + (*p - '0');
      p++;
   }
   sprintf(format, "echo %d >%s", port, FILE_KTSERV_PORT);
   system(format);
   sprintf(format, "echo %d >%s", getpid(), FILE_KTSERV_PID);
   system(format);

}

/***********************************************************************
 * Public
 **********************************************************************/

/*
** Side effect : assign the variable Port to the ICE port
*/
void
kts_advertiseMyPresence(GV gv, int count, IceListenObj *obj)
{
   char *pNumber, *pStr, *p;
   char *display, strNumber[128];


   pStr = IceGetListenConnectionString(kts_nonLocalListenObj(count, obj));
   p = pStr;
   /*
   ** Try to turn the hostname (string) into IP numbers, so that
   ** if the hostname isn't fully qualified, it works anyway
   */
   {
       char hostName[128], *pHostName = hostName, *p2;
       char *tcpString = "tcp/";
       struct hostent *h;
       p2 = strstr(pStr, tcpString);
       if (NULL != p2) {
	   p2 += strlen(tcpString);
	   while (':' != *p2) *pHostName++ = *p2++;
	   *pHostName = '\0';

	   h = gethostbyname(hostName);
	   if (NULL != h) {
	       unsigned int port = 0;
	       while (*p && *p != ':') p++;
	       if (*p) p++;
	       while (*p) {
		   port = (port * 10) + (*p - '0');
		   p++;
	       }
	       sprintf(strNumber, "%s%u.%u.%u.%u:%u",
		       tcpString,
		       (unsigned char) h -> h_addr_list[0][0],
		       (unsigned char) h -> h_addr_list[0][1],
		       (unsigned char) h -> h_addr_list[0][2],
		       (unsigned char) h -> h_addr_list[0][3],
		       port);
	       p = kt_strdup(strNumber);
	   }
       }
   }

   kts_storeCoordinatesOnFile(gv, p);
   /*
   ** Store coordinates on display, if possible
   */
   display = getenv("DISPLAY");
   if (0 != display) {
      kts_storeCoordinatesOnDisplay(gv, p, display);
      DP(printf("ktserv pid %d starting '%s', display '%s'\n",
		getpid(), p, display));
   }
   else
      DP(printf("Server starting on '%s'\n", p));

   /*
   ** Register to the portmapper
   */
#ifndef NO_RPC
   kts_storeCoordinatesOnPortmapper(gv, IceGetListenConnectionNumber(obj[1]));
#endif

   /*
   ** Damn RPC, won't let me give a closure to my dispatch procedure
   */
   ServerLocation = kt_strdup(p);
   free(p);
}

