/* Copyright (C) 1994 Groupe BULL. See file COPYRIGHT for details */
/*
 *
 * $Id: kt_peer.c,v 1.2 1994/12/16 16:22:26 beust Exp $
 */

#include <stdio.h>
#include <assert.h>
#include "kt_lib.h"
#include "kt_protocolP.h"
#include "kt_typesP.h"
#include "database.h"


/*
static DataBase _PeerConnections = NULL;
*/

/****************************************************************************
 * Private
 ****************************************************************************/


/*
**---------------------------------------------------------------------------
** kt_peerProcessMsg
** Called each time a direct packet arrives
*/
static void
kt_peerProcessMsg()
{
   printf("peer processmsg!\n");
}



/****************************************************************************
 * Public
 ****************************************************************************/

/*
**---------------------------------------------------------------------------
** kt_peerOpenConnection
*/

static Bool
kt_findPeerConnectionByIce(Kt_PeerConnection pc, IceConn iceConn)
{
    if (pc -> iceConn == iceConn) return True;
    else return False;
}

Kt_PeerConnection
kt_PeerOpenConnection(Kt_Context context, char *peerLocation)
{
   Kt_CallbackAddInput addInput = context -> addInput;
   IceConn conn;
   int status;
   int majVer, minVer;
   char *kt_identity;
   int prot;
   Kt_PeerConnection result = NULL;
   IcePoVersionRec callbackList[] = {
      { 1, 0, (IcePoProcessMsgProc) kt_peerProcessMsg }
   };

   _kt_openConnection(peerLocation, PDIRECT_NAME, PDIRECT_RELEASE,
		     callbackList, & conn, & prot);

   if (NULL == conn) {
      fprintf(stderr, "OpenPeerConnection: couldn't open connection\n");
      result = NULL;
   }
   else {
       /*
       ** Check if we haven't opened an Ice Connection to this peer
       ** already. If we did, return the already existing entry,
       ** otherwise add it to our base
       */
       result = DB_LocateEntry(context -> directConn,
		       (void *) ((unsigned long) kt_findPeerConnectionByIce),
		       (void *) ((unsigned long) conn));

       if (NULL == result) {
	   NEW(result, Kt_PeerConnectionRec);
	   result -> iceConn = conn;
	   result -> protocol = prot;
	   DB_AddEntry(context -> directConn, result);
	   
	   /*
	   ** Add the fd to the list of those we watch
	   */
	   (*addInput)(IceConnectionNumber(conn), context -> addInputUserData);
       }
   }
   return result;
}

/*
**---------------------------------------------------------------------------
** kt_SetPeerErrorHandler
*/
void
kt_PeerSetErrorHandler(Kt_Context context, Kt_PeerConnection peer, void *handler)
{
   ASSERT(0);
}

/*
**---------------------------------------------------------------------------
** kt_PeerReturnIceConnection
*/
IceConn
kt_PeerReturnIceConnection(Kt_PeerConnection peer)
{
   return peer -> iceConn;
}

/*
**---------------------------------------------------------------------------
** kt_PeerReturnIceProtocol
*/
int
kt_PeerReturnIceProtocol(Kt_PeerConnection peer)
{
   return peer -> protocol;
}

/*
**---------------------------------------------------------------------------
** kt_PeerAddMsgCallback
*/
void
kt_PeerAddMsgCallback(Kt_Context context,
		      Kt_CallbackPeerMsg callback, void *userData)
{
   context -> directCallback = callback;
   context -> directClosure = userData;
}


