/* Copyright (C) 1994 Groupe BULL. See file COPYRIGHT for details */
/*
 *
 * $Id: kt_compat.c,v 1.2 1994/12/15 13:38:30 beust Exp beust $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* ......................................................................
**
** Solaris compatibility
**
*/

#ifdef SYSV
#define KT_SYSTEM5
#endif

#ifdef SVR4
#define KT_SYSTEM5
#endif

#ifdef KT_SYSTEM5

/*
** Following symbols needed by libXm.a 1.2 :-( (the define is not enough)
*/
void
bcopy(void *s, void *d, void *l)
{
    memcpy(d, s, l);
}

int
re_exec(void *prog, void *string)
{
    return regexec(prog, string);
}

int
re_comp(void *exp)
{
   return regcomp(exp); 
}

/* For the rest, #defines should be enough */

#define index strchr
#define rindex strnchr
#define bcopy(s,d,l) memmove(d,s,l)
#define bzero(s,l) memsel(s,0,l)
#define bcmp memcmp

#include <sys/time.h>
#include <sys/resource.h>
 
int
kt_getdtablesize()
{
   struct rlimit limit;
   if (getrlimit(RLIMIT_NOFILE, &limit) < 0) {
      perror("getdtablesize");
      exit(-1);
   }
   return limit.rlim_cur;
}

#else

int
kt_getdtablesize()
{
   return getdtablesize();
}
#endif   /* KT_SYSTEM5 */


/* ......................................................................
**
** strdup() stub
**
*/

char *
kt_strdup(char *s)
{
   char *result;
   if (0 == s) {
      fprintf(stderr, "warning: kt_strdup() passed 0\n");
      return (char *) ((unsigned long) 0);   /* alpha kludge */
   }
   result = (char *) malloc(strlen(s) + 1);
   strcpy(result, s);
   return result;
}

