//
// Copyright (C) 1994-1995 Harry Danilevsky and Andrew Renalds
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish and distribute copies of the 
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESSED OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// HARRY DANILEVSKY AND ANDREW RENALDS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#include <stream.h>
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/RowColumn.h>
#include <Xm/DrawnB.h>
#include <Xm/PushB.h>
#include <DD++/DDstring.H>
#include <DD++/DDint.H>
#include <DD++/DDdouble.H>
#include <DD++/SpecificDragSite.H>


Widget createButton(Widget parent, char *pixmapFileName)
{
  Pixel fg, bg;
  XtVaGetValues( parent, XmNforeground, &fg, XmNbackground, &bg, NULL );
  Pixmap pmap = XmGetPixmap( XtScreen( parent ), pixmapFileName, fg, bg );

  int n = 0;
  Arg args[10];
  XtSetArg( args[n], XmNwidth, 75 );  n++;
  XtSetArg( args[n], XmNheight, 75 );  n++;
  XtSetArg( args[n], XmNx, 5 );  n++;
  XtSetArg( args[n], XmNy, 5 );  n++;
  XtSetArg( args[n], XmNshadowType, XmSHADOW_OUT );  n++;
  XtSetArg( args[n], XmNlabelType, XmPIXMAP );  n++;
  if( pmap != XmUNSPECIFIED_PIXMAP )  
  {
    XtSetArg( args[n], XmNlabelPixmap, pmap );  n++;
  }
  return  XtCreateManagedWidget( "", xmDrawnButtonWidgetClass,
				 parent, args, n );
}

main( int argc, char *argv[] )
{
  XtAppContext app_context;
  Widget toplevel, bb, button1, button2, button3;
  Arg args[15];
  int n;

  toplevel = XtAppInitialize( &app_context, "DragTest", NULL, 0,
                              &argc, argv, NULL, NULL, 0 );

  n = 0;

  XtSetArg( args[n], XmNorientation, XmVERTICAL );  n++;
  XtSetArg( args[n], XmNpacking, XmPACK_COLUMN );  n++;

  bb = XtCreateManagedWidget( "", xmRowColumnWidgetClass,
                              toplevel, args, n );

  button1 = createButton(bb, "dog.xpm");
  button2 = createButton(bb, "dragon.xpm");
  button3 = createButton(bb, "c++.xpm");

  DraggableString dstring("Hello");
  SpecificDragSite dragSite1(button1, XmBLEND_JUST_SOURCE, "dog.xpm");
  dragSite1.objectToDrag(dstring);

  DraggableInt dint(123); 
  SpecificDragSite dragSite2(button2, XmBLEND_JUST_SOURCE, "dragon.xpm");
  dragSite2.objectToDrag(dint);

  DraggableDouble ddouble(1/3.0); 
  SpecificDragSite dragSite3(button3, XmBLEND_JUST_SOURCE, "c++.xpm");
  dragSite3.objectToDrag(ddouble);

  XtRealizeWidget( toplevel );
  XtAppMainLoop( app_context );
}
