//
// Copyright (C) 1994-1995 Harry Danilevsky and Andrew Renalds
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish and distribute copies of the 
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESSED OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// HARRY DANILEVSKY AND ANDREW RENALDS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#ifdef HAVE_XPMLIB
#include <X11/xpm.h>
#endif

#include <DD++/XPixmap.H>

XPixmap::XPixmap( Widget w, char* pixmapName, char* pixmapMaskName ) :
	widget(w), pixmap(XmUNSPECIFIED_PIXMAP), mask(XmUNSPECIFIED_PIXMAP)
{
#ifdef HAVE_XPMLIB
  XpmAttributes attrib;

  if( pixmapName && strstr( pixmapName, ".xpm" ) != NULL )
  {
    attrib.valuemask = XpmReturnPixels;
    attrib.width = 0;
    attrib.height = 0;
    attrib.depth = DefaultDepthOfScreen( XtScreen(w) );
    attrib.visual = DefaultVisual( XtDisplay(w), DefaultScreen(XtDisplay(w)) );
    attrib.colormap = XDefaultColormapOfScreen( XtScreen(w) );
    if( XpmReadFileToPixmap( XtDisplay(w), XRootWindowOfScreen(XtScreen(w)),
	 	pixmapName, &pixmap, &mask, &attrib ) != XpmSuccess )
    {
	pixmap = XmUNSPECIFIED_PIXMAP;
	mask = XmUNSPECIFIED_PIXMAP;
    }
    else
    {
	width = attrib.width;
	height = attrib.height;
	depth = attrib.depth;
    }
    XpmFreeAttributes(&attrib);
  }
#endif

  if( pixmapName && pixmap == XmUNSPECIFIED_PIXMAP )
  {
    Window rootWindow;
    int x, y;
    unsigned int bdw;
    Pixel bg, fg;

    XtVaGetValues( w, XmNforeground, &fg, XmNbackground, &bg, NULL );

    pixmap = XmGetPixmap( XtScreen(w), pixmapName, fg, bg );
    if( pixmap != XmUNSPECIFIED_PIXMAP )
      XGetGeometry( XtDisplay(w), pixmap, &rootWindow, &x, &y, 
		  &width, &height, &bdw, &depth );

    if( pixmapMaskName )
	mask = XmGetPixmap( XtScreen(w), pixmapMaskName, fg, bg );
  }
}

XPixmap::~XPixmap()
{
  // free pixmaps (if they have been successfully created in ctor)
  if( pixmap != XmUNSPECIFIED_PIXMAP )
    XFreePixmap(XtDisplay(widget), pixmap);
  if( mask != XmUNSPECIFIED_PIXMAP )
    XFreePixmap(XtDisplay(widget), mask);
}


Widget XPixmap::createDragIcon( ) const
{
  if( pixmap != XmUNSPECIFIED_PIXMAP )
  {
    Arg args[4];
    XtSetArg( args[0], XmNpixmap, pixmap );
    XtSetArg( args[1], XmNwidth, width );
    XtSetArg( args[2], XmNheight, height );
    XtSetArg( args[3], XmNdepth, depth );
    return( XmCreateDragIcon( widget, "XPixmap", args, 4 ) );
  } 
  else
    return( (Widget)NULL );
}
