#ifndef _XPIXMAP_H_
#define _XPIXMAP_H_

//
// Copyright (C) 1994-1995 Harry Danilevsky and Andrew Renalds
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish and distribute copies of the 
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESSED OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// HARRY DANILEVSKY AND ANDREW RENALDS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <Xm/Xm.h>
#include <Xm/DragDrop.h>

class XPixmap
{
private:

  Widget		widget;
  Pixmap 		pixmap, mask;
  unsigned int	width, height, depth;

public:

  XPixmap( Widget w, char* pixmapName, char* pixmapMaskName=NULL );
  ~XPixmap();

  Pixmap getPixmap() const {
    return pixmap;
  }
  Pixmap getMask() const {
    return mask;
  }
  unsigned int getWidth() const {
    return width;
  }
  unsigned int getHeight() const {
    return height;
  }
  unsigned int getDepth() const {
    return depth;
  }

  Widget createDragIcon( ) const;
};

#endif
