#ifndef _DD_H_
#define _DD_H_
//
// Copyright (C) 1994-1995 Harry Danilevsky and Andrew Renalds
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish and distribute copies of the 
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESSED OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// HARRY DANILEVSKY AND ANDREW RENALDS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <Xm/AtomMgr.h>
#include <Xm/DragDrop.h>
#include <iostream.h>
#include <strstream.h>
// #include "DD++/SLList.h"
#include "DD++/XPixmap.H"
#ifdef DD_USE_XDR
#include "DD++/DDstream.H"
typedef DDostream o_stream;
typedef DDistream i_stream;
#else
typedef ostream o_stream;
typedef istream i_stream;
#endif


class Draggable 
{
  protected:
    // format telling X server how to byte-swap data (must be 8, 16 or 32)
    virtual int         format() { return 8; }

    // name of property associated with the atom number
    virtual const char* atomName() const = 0;

    // saves object onto and from stream
    virtual void saveOn(o_stream &o) = 0;
    virtual void restoreFrom(i_stream &i, int dataSize) = 0;

    // operation-specific functions which get called to save the
    // object to a stream
    virtual void doCopy(o_stream& o) {saveOn(o);}
    virtual void doMove(o_stream& o) {saveOn(o);}
    virtual void doLink(o_stream& o) {saveOn(o);}

  private:
    Atom atom;

    friend class DragSite;
    friend class DropSite;
    friend class DropTarget;
};

class DragSite 
{
private:
  Draggable *dPtr;
  const char *actionName;
  static XContext contextId;	// unique id in context manager for DragSite
  void dragActionProc(XEvent *, String *params, Cardinal *nparams);
  static void startDrag(Widget, XEvent *, String *params, Cardinal *nparams);
  static Boolean DragConvertProc( Widget w, Atom *selection, Atom *target,
				  Atom *typeRtn, XtPointer *valueRtn,
				  unsigned long *lengthRtn, int *formatRtn,
				  unsigned long *max_lengthRtn,
				  XtPointer client_data, XtRequestId *request_id);
  DragSite(const DragSite &);
  DragSite& operator = (const DragSite &);
  
protected:
  Widget w;
  
  // sets the visual drag effects, etc...
  virtual Cardinal dragContextProperties(ArgList*);
  
  // sets up which keys will do which operation
  virtual const char* dragKey(int) const;
  
public:
  DragSite(Widget aWidget,
	   const char* actionName_ = NULL,
	   Boolean setDefaultDragKeys = True);
  virtual ~DragSite() {
    XDeleteContext( XtDisplay( w ),
		    (XID) w,
		    (XContext) contextId );
  }
  void setDragKeys();
  void objectToDrag(Draggable& t);
  void deactivate() { dPtr = NULL; }
  static char *DefaultActionName;
};


class DropTarget 
{
private:
    virtual int receive (Widget) = 0;
protected:
    Draggable *dPtr;
public:
    DropTarget(Draggable& t) { dPtr = &t; }
    friend class DropSite;
};

typedef DropTarget* DropTargetPtr;

class DropSite
{
private:
    struct Node
    {
      DropTargetPtr	data;
      Node		*next;
    };
    Node *last;

    static void dropCB( Widget w, XtPointer client_data, 
			XtPointer call_data );
    static void transferCB( Widget w, XtPointer client_data, Atom *seltype, 
			    Atom *type, XtPointer value, 
			    unsigned long *length, int format );
    void handleDrop( XtPointer client_data, XtPointer call_data );
    static XContext contextId;	// unique id in context manager for DropSite
protected:
    Widget w;
    unsigned char operations;
    int animationPixmapStyle;
    XPixmap *animationPixmap, *animationMaskPixmap;
public:
    DropSite( Widget aWidget, 
	      unsigned char ops = XmDROP_COPY,
	      int animationPixmapStyle_=XmDRAG_UNDER_HIGHLIGHT,
	      char *animationPixmapName=NULL, 
	      char *animationMaskPixmapName=NULL );
    DropSite& append(DropTargetPtr);
    DropSite& remove(DropTargetPtr);
    virtual ~DropSite();
};

#endif
