/* 
 * X Development Tools Library
 * $Id: Xdt.h,v 1.1 1996/04/01 03:48:28 rwerne Exp rwerne $
 * 
 * Written by Robert Werner.
 * Copyright (c) 1995, 1996 by Software Komponents International.
 * All Rights Reserved.  See the file COPYRIGHT for details.
 * This is not public domain software.  See the file LICENSE for details.
 * There is no warranty for this software.  See NO_WARRANTY for details.
 */

#ifndef __Xdt_Xdt_h_
#define __Xdt_Xdt_h_

/*
 * Standard X header files
 */
#include <X11/Intrinsic.h>
#include <X11/Xfuncproto.h>


/*
 * Specify what version of Xdt this is.
 */
#define XdtVERSION      1
#define XdtREVISION     0
#define XdtVersion      (XdtVERSION * 1000 + XdtREVISION)
#define XdtPatchlevel   0

/*
 * figure out what version of Xt we're using.
 */
#if XtSpecificationRelease >= 5
#  define X11R5
#else
#  undef X11R5
#endif
#if XtSpecificationRelease >= 6
#  define X11R6
#else
#  undef X11R6
#endif

/*
 * const String s; is the same as char * const s; not const char *s;
 * The latter is really what we want.  As a workaround, we define
 * a new type StringConst which is a const char *.
 * Note that we can declare: const XdtStringConst s;
 *
 * Comments derived from Xmt.h, written by David Flanagan
 */
#if __STDC__ || defined(__cplusplus) || defined(c_plusplus)
   typedef const char *XdtStringConst;
#  ifndef _Xconst
#     define _Xconst const
#  endif
#else
   typedef char *XdtStringConst;
#  ifndef _Xconst
#     define _Xconst /* as nothing */
#  endif
#endif

/*
 * The underscore macro is a somewhat common shortcut to support full
 * ANSI prototypes, while also being compatible with non-ANSI compilers.
 * Write the prototype like this:
 *
 * void function _(( type arg, type arg ));
 *
 */
#ifndef _
#  if NeedFunctionPrototypes
#     define _(p)	p
#  else
#     define _(p)	()
#  endif
#endif

/*
 * In K&R C, function arguments are all made at least as long as an int.
 * In ANSI-C, using prototypes, it is possible to pass function arguments
 * in their "narrow" form.  This library might be compiled with an ANSI
 * compiler, but linked with code compiled with K&R, so we have to be
 * careful not to use narrow arguments in this way, unless we are
 * explicitly told not to worry about it.
 *
 * Client code generally doesn't need to worry about being compiled with
 * mixed compilers, so you shouldn't have to use these.  If you do, only
 * use them in the prototypes for function definitions and declarations,
 * not as variables or structure fields.
 *
 * Comments taken from Xmt.h, written by David Flanagan
 */
#if NeedWidePrototypes /* almost always defined to True */
#  define XdtWideBoolean int
#else
#  define XdtWideBoolean Boolean
#endif

#endif
