/* 
 * X Development Tools Library
 * $Id: ResMgmt.c,v 1.1 1996/04/01 03:48:28 rwerne Exp rwerne $
 * 
 * Written by Robert Werner.
 * Copyright (c) 1995, 1996 by Software Komponents International.
 * All Rights Reserved.  See the file COPYRIGHT for details.
 * This is not public domain software.  See the file LICENSE for details.
 * There is no warranty for this software.  See NO_WARRANTY for details.
 */

#include <ctype.h>
#include <X11/StringDefs.h>
#include <Xdt/ResMgmt.h>



#if NeedFunctionPrototypes
void XdtGetResource(
   Widget         w,
   XtPointer      base,
   XdtStringConst subpart_name,
   XdtStringConst subpart_class,
   XtResourceList resources,
   Cardinal       num_resources )
#else
void XdtGetResource( w, base, subpart_name, subpart_class, resources,
                     num_resources )
   Widget         w;
   XtPointer      base;
   XdtStringConst subpart_name;
   XdtStringConst subpart_class;
   XtResourceList resources;
   Cardinal       num_resources;
#endif
{
   String app_name;
   String app_class;
   
   XtGetApplicationNameAndClass( XtDisplay( w ), &app_name, &app_class );
   
   XdtQGetLibraryResource( 
      w, 
      base, 
      XrmStringToQuark( app_name ),   /* I'm not using XrmPermStringToQuark() */
      XrmStringToQuark( app_class ),  /* because the Intrinsics own the data  */
      XrmPermStringToQuark( XdtNcommon ),
      XrmPermStringToQuark( XdtCCommon ), 
      subpart_name,
      subpart_class,
      resources,
      num_resources );
}

/*----------------------------------------------------------------------------*/

#if NeedFunctionPrototypes
void XdtGetLibraryResource(
   Widget         w,
   XtPointer      base,
   XdtStringConst library_name,
   XdtStringConst library_class,
   XdtStringConst subpart_name,
   XdtStringConst subpart_class,
   XtResourceList resources,
   Cardinal       num_resources )
#else
void XdtGetLibraryResource( w, base, library_name, library_class, subpart_name,
                            subpart_class, resources, num_resources )
   Widget         w;
   XtPointer      base;
   XdtStringConst library_name;
   XdtStringConst library_class;
   XdtStringConst subpart_name;
   XdtStringConst subpart_class;
   XtResourceList resources;
   Cardinal       num_resources;
#endif
{
   String app_name;
   String app_class;
   
   XtGetApplicationNameAndClass( XtDisplay( w ), &app_name, &app_class );
   
   XdtQGetLibraryResource( 
      w, 
      base, 
      XrmStringToQuark( app_name ),   /* I'm not using XrmPermStringToQuark() */
      XrmStringToQuark( app_class ),  /* because the Intrinsics own the data  */
      XrmStringToQuark( library_name ),
      XrmStringToQuark( library_class ), 
      subpart_name,
      subpart_class,
      resources,
      num_resources );
}
   
/*----------------------------------------------------------------------------*/

#if NeedFunctionPrototypes
void XdtQGetLibraryResource(
   Widget         w,
   XtPointer      base,
   XrmQuark       app_name,
   XrmQuark       app_class,
   XrmQuark       library_name,
   XrmQuark       library_class,
   XdtStringConst subpart_name,
   XdtStringConst subpart_class,
   XtResourceList resources,
   Cardinal       num_resources )
#else
void XdtQGetLibraryResource( w, base, app_name, app_class, library_name, 
                             library_class, subpart_name, subpart_class, 
                             resources, num_resources )
   Widget         w;
   XtPointer      base;
   XrmQuark       app_name;
   XrmQuark       app_class;
   XrmQuark       library_name;
   XrmQuark       library_class;
   XdtStringConst subpart_name;
   XdtStringConst subpart_class;
   XtResourceList resources;
   Cardinal       num_resources;
#endif
{
   int        i;
   String     value_str;
   XtResource resource;
   char       indirect_name[ 81 ];
   Boolean    resource_retrieved;
   
   /*
    * Perform lookup for each desired resource
    */
   for (i = 0; i < num_resources; i++)
   {
      resource_retrieved = FALSE;
      
      /*
       * Initially, retrieve specified resource as a string to that it
       * can be examined for indirection
       */
      resource.resource_name   = resources[ i ].resource_name;
      resource.resource_class  = resources[ i ].resource_class;
      resource.resource_type   = XtRString;
      resource.resource_size   = (Cardinal) sizeof( String );
      resource.resource_offset = (Cardinal) 0;
      resource.default_type    = XtRImmediate;
      resource.default_addr    = NULL;

      XtGetSubresources(
	 w,		&value_str,
	 subpart_name,	subpart_class,
	 &resource,	(Cardinal) 1,
	 NULL,		(Cardinal) 0 );
      
      /*
       * Check if the value is enclosed in square brackets; if so, the
       * contents within the beackets is the indirect name.  If the
       * square brackets are not found, then no indirection exists
       * and the resource should simply re retrieved as specified.
       */
      *indirect_name = '\0';
      if (value_str && (*value_str == '['))
      {
         int len;
         
         len = strlen( value_str );
         if (value_str[ len - 1  ] == ']')
         {
            strcpy( indirect_name, value_str + 1 );
            indirect_name[ len - 2 ] = '\0';
         }
      }
      
      if (*indirect_name)
      {
         XrmQuark          quark_name_list [ 5 ];
         XrmQuark          quark_class_list[ 5 ];
         XrmRepresentation quark_rep;
         char              type_str[ 81 ];
         XrmValue          xrm_pre_value;
         XrmValue          xrm_post_value;
         Bool              xbool;
         
         strcpy( type_str, resources[ i ].resource_type );
         
         if (isupper( *indirect_name ))
         {
            *indirect_name = tolower( *indirect_name );
         }
         if (isupper( *type_str ))
         {
            *type_str = tolower( *type_str );
         }
         
         quark_name_list[ 0 ] = app_name;
         quark_name_list[ 1 ] = library_name;
         quark_name_list[ 2 ] = XrmStringToQuark( type_str      );
         quark_name_list[ 3 ] = XrmStringToQuark( indirect_name );
         quark_name_list[ 4 ] = NULLQUARK;
         
         *indirect_name = toupper( *indirect_name );
         *type_str      = toupper( *type_str      );
         
         quark_class_list[ 0 ] = app_class;
         quark_class_list[ 1 ] = library_class;
         quark_class_list[ 2 ] = XrmStringToQuark( type_str      );
         quark_class_list[ 3 ] = XrmStringToQuark( indirect_name );
         quark_class_list[ 4 ] = NULLQUARK;

         /*
          * Retrieve the indirect resource
          */         
         xbool = XrmQGetResource(
            XrmGetDatabase( XtDisplay( w ) ),
            quark_name_list,
            quark_class_list,
            &quark_rep,
            &xrm_pre_value );
            
         if (xbool)
         {
            /*
             * Convert the retrieved resource into the appropriate data type
             */
            xrm_post_value.size = 0;
            xrm_post_value.addr = NULL;
            
            XtConvert(
               w,
               XrmQuarkToString( quark_rep ),
               &xrm_pre_value,
               resources[ i ].resource_type,
               &xrm_post_value );
               
            if (xrm_post_value.size > 0)
            {
               if (strcmp( resources[ i ].resource_type, XtRString ) == 0)
               {
                  String tmp = XtNewString( (String) xrm_post_value.addr );
                  
        	  memcpy( base + resources[ i ].resource_offset, 
                	  (void*) &tmp,
                	  sizeof( String ) );
                    
        	  resource_retrieved = TRUE;
               }
               else if (xrm_post_value.size <= resources[ i ].resource_size)
               {
        	  memcpy( base + resources[ i ].resource_offset, 
                	  xrm_post_value.addr,
                	  xrm_post_value.size );

        	  resource_retrieved = TRUE;
               }
            }
         }
      }
      
      /*
       * If the resource is not indirect or if the indirect could not
       * be retrieved, then try to retrieve it the standard way.
       */
      if (!resource_retrieved)
      {
	 XtGetSubresources(
	    w,			base,
	    subpart_name,	subpart_class,
	    resources + i,	(Cardinal) 1,
	    NULL,		(Cardinal) 0 );
      }
   }
}
