#ifndef XCLASSES_CONFIG_H
#define XCLASSES_CONFIG_H

#include <Xclasses/dlist.h>
#include <Xclasses/Xdisplay.h>
#include <stdio.h>

class config
{
	friend class pconfig;
	class pconfig *p;
public:
	config(char *name);
	virtual ~config();

	void SetItems(struct configopts *);
	void SetDisplayConfig(class Xdisplay *);
	void SetDisplayConfig(class Xdisplay &d) { SetDisplayConfig(&d); };
	int Read(void);  // 0 - Ok
	int Write(void); // 0 - Ok
	int RootWrite(void); // 0 - Ok
};

struct configopts
{
	char *name;
	char *data;
};

// name pattern: "Xss:name"
// X:  S string - ss: max size
// X:  T string like S, but if empty or NULL not written
//     I int
//     B bool
//     W switch
//     E enum - ss: enums, ex: "eenum1,enum2,enum3:name", no "-" allowed!
//
// extra options start with "-", e.g. "S-A:name" (but A is currently nothing!)
// absolut path in constructor disables personal config read/write

#endif
