#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <Xclasses.h>

#ifndef FONT_GADGET
#define TGGFONT "-*-helvetica-medium-r-*-*-8-*-*-*-*-*-*-*"
#define SGGFONT "-*-helvetica-medium-r-*-*-10-*-*-*-*-*-*-*"
#define GGFONT "-*-helvetica-*-r-*-*-12-*-*-*-*-*-*-*"
#define FIXGGFONT "-*-courier-medium-r-*-*-14-*-*-*-*-*-*-*"
#define BGGFONT "-*-helvetica-*-r-*-*-16-*-*-*-*-*-*-*"
#define GPFONT "-*-helvetica-medium-r-*-*-10-*-*-*-*-*-*-*"
#else
#define TGGFONT "-*-helvetica-medium-r-*-*-8-*-*-*-*-*-*-*"
#define SGGFONT FONT_SMALL
#define GGFONT FONT_GADGET
#define FIXGGFONT FONT_FIXED
#define BGGFONT FONT_BIG
#define GPFONT FONT_GROUP
#endif

appwindow mainwin("panel");
group maingp,main2,main3;
bordergroup kontrolle;
bordergroup sg1[2],sg2[4];
menu mymenu;

text status;
dirview dir;
input dir_in;

mxbutton kontrollbut;
char *kbuts[]={"Programme","Verzeichnis","Diskette","WWW",NULL,"Ende",NULL};
#define KBUTS	5

#define MAXBUTS	5
button b[MAXBUTS];
char *btxt[MAXBUTS]={"Shell",
					 "Netscape",
					 "Verbindung RZ",
					 "Verbindung AI-RZ",
					 "Post lesen",
					 };
char *bcom[MAXBUTS]={"xterm -sb -sl 500 -j -ls -fn 7x14 -bg white &",
					 "netscape &",
					 "xterm -T \"telnet pcserver\" -n \"telnet pcserver\" -fg blue -sb -sl 500 -j -ls -fn 7x14 -e telnet pcserver &",
					 "xterm -T \"telnet sunserver\" -n \"telnet sunserver\" -fg blue -sb -sl 500 -j -ls -fn 7x14 -e telnet sunserver &",
					 "xterm -T \"Post lesen\" -n \"ELM\" -fg blue -sb -sl 500 -j -ls -fn 7x14 -e elm &",
					 };
char *htxt[MAXBUTS]={"ffnet neues Fenster",
					 "startet Netscape Navigator",
					 "ffnet Fenster zum\nEinloggen ins Rechenzentrum",
					 "ffnet Fenster zum\nEinloggen ins AI-Rechenzentrum",
					 "startet ELM zum Lesen der Post,\nmit Taste 'q' beenden"
					 };
text ueber;
button anleitung;
button cb1,cb2;
button wb1,wb2,wb3;

group diskgp;
listview disk;
button db1,db2,db3,db4;

dlist diskfiles;
easy_dialog	yesno;

char olddir[400];
int md=0;
void remove_disk(void)
{
	struct node *n;
	
	while (n=diskfiles.RemTail())
	{
		delete n->text;
		delete n;
	}
}
node *add_disk(char *name)
{
	struct node *n=NULL;

	if (n=new node)
	{
		if (n->text=new char[strlen(name)+1])
		{
			strcpy(n->text,name);
			diskfiles.AddTail(n);
		}
		else
		{
			delete n;
			n=NULL;
		}
	}
	return n;
}

char status_buf[1000];
int System(char *com)
{
	FILE *datei;
	char buf[100];
	int l=0;

	status_buf[0]=0;
	status.Text(status_buf); mainwin.Update();

	if (datei=popen(com,"r"))
	{
		while (!feof(datei))
		{
			if (fgets(buf,sizeof(buf),datei))
			{
				l++;
				strcat(status_buf,buf);
				status.Text(status_buf); mainwin.Update();
			}
		}
		pclose(datei);
	}
	return l>1;
}

void read_disk(void)
{
	FILE *datei;
	char buf[100],*name;
	int l;
	
	maingp.Lock();
	disk.RemoveAll();
	remove_disk();
	if (datei=popen("mdir","r"))
	{
		while (!feof(datei))
		{
			if (fgets(buf,sizeof(buf),datei))
			{
				if (buf[strlen(buf)-1]=='\n') buf[strlen(buf)-1]=0;
			}
			if (buf[0]!=' ' && (l=strlen(buf))>1)
			{
				buf[12]=0;
				name=buf; // ab 42
				if (l>42)
				{
					name=&buf[42];
				}
				else
				{
					int j=13;
					for(int i=0;i<12;i++)
					{
						if (buf[i]!=' ')
						{
							buf[j]=buf[i];
							j++;
						}
						if (i==8)
						{
							buf[j]='.';
							j++;
						}
					}
					buf[j]=0;
					name=&buf[13];
				}

				disk.AddAtEnd(name,add_disk(name));
			}
		}
		pclose(datei);
	}
	maingp.Unlock();
} 
// mcopy -O -a
void copy_from(void)
{
	if (disk.Selected())
	{
		maingp.Lock();
		char buf[350],dirbuf[300];
		dir.GetDir(dirbuf,sizeof(dirbuf));
		sprintf(buf,"mcopy -O -o -n \"a:%s\" \"%s\" 2>&1",((node*)disk.GetData(disk.Selected()))->text,dirbuf);
		System(buf);
		dir.RereadDir();
		maingp.Unlock();
	}
}
void del_file(void);
void copy_to(void)
{
	char buf[500],dirbuf[300],filebuf[200];
	dir.GetDir(dirbuf,sizeof(dirbuf));
	dir.GetFile(filebuf,sizeof(filebuf));
	if (strlen(filebuf))
	{
		maingp.Lock();
		sprintf(buf,"mcopy -O -o -n \"%s%s\" a: 2>&1",dirbuf,filebuf);
		if (!System(buf))
		{
			maingp.Unlock();
			yesno.Text("Die Datei wurde erfolgreich kopiert. Soll\ndas Original auf der Festplatte nun gelscht werden?");
			yesno.Options("Ja|Nein");
			if (yesno.Start(mainwin)==1)
			{
				del_file();
			}
		}
		else
		{
			maingp.Unlock();
		}
		read_disk();
	}
}
void del_disk(void)
{
	if (disk.Selected())
	{
		char buf[200];
		maingp.Lock();
		sprintf(buf,"Das File '%s'\nwirklich von Diskette lschen?",((node*)disk.GetData(disk.Selected()))->text);
		yesno.Text(buf);
		yesno.Options("Ja|Nein");
		if (yesno.Start(mainwin)==1)
		{
			sprintf(buf,"mdel \"a:%s\" 2>&1",((node*)disk.GetData(disk.Selected()))->text);
			System(buf);
			read_disk();
		}
		maingp.Unlock();
	}
}
void run_edit(void)
{
	char buf[500],dirbuf[300],filebuf[200];
	dir.GetDir(dirbuf,sizeof(dirbuf));
	dir.GetFile(filebuf,sizeof(filebuf));
	if (strlen(filebuf))
	{
		sprintf(buf,"nedit \"%s%s\" &",dirbuf,filebuf);
		system(buf);
		dir.RereadDir();
	}
}
void del_file(void)
{
	char buf[500],dirbuf[300],filebuf[200];
	dir.GetDir(dirbuf,sizeof(dirbuf));
	dir.GetFile(filebuf,sizeof(filebuf));
	if (strlen(filebuf))
	{
		strcpy(buf,dirbuf);
		strcat(buf,filebuf);
		sprintf(dirbuf,"Das File '%s'\nwirklich lschen?",filebuf);
		yesno.Text(dirbuf);
		yesno.Options("Ja|Nein");
		if (yesno.Start(mainwin)==1)
		{
			remove(buf);
			dir.RereadDir();
		}
	}
}
void www_frei(void)
{
	char buf[500],dirbuf[300],filebuf[200];
	dir.GetDir(dirbuf,sizeof(dirbuf));
	dir.GetFile(filebuf,sizeof(filebuf));

	strcpy(buf,dirbuf);
	strcat(buf,filebuf);
	if (strlen(filebuf))
	{
		chmod(buf,S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
	}
	else
	{
		yesno.Text("Bei dem angewhlten File handelt es sich um das\naktuelle Verzeichnis.\nDieses wird jetzt freigegeben.");
		yesno.Options("Ok");
		yesno.Start(mainwin);
		chmod(buf,S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH);
	}
	dir.RereadDir();
	status.Text("freigegeben");
}
void show_anleitung(void)
{
	yesno.Text("'panel' ermglicht es ber eine einfach zu bedienende Oberflche\n"
			   "seinen Account, sein Homeverzeichnis und seine WWW-Seiten zu verwalten\n"
			   "und bietet zudem eine einfache Bedienung des Diskettenlaufwerks und\n"
			   "eine Liste von Programmen, die man sofort starten kann.\n\n"
			   "Oben rechts befindet sich eine Liste, ber die verschiedene\n"
			   "Modi erreicht werden knnen:\n - 'Programme' zum Starten von Programmen\n"
			   " - 'Verzeichnis' zum Arbeiten mit den Files im Home-Verzeichnis\n"
			   " - 'Diskette' zum Kopieren von Files von und auf Diskette\n"
			   " - 'WWW' zum Bearbeiten der eigenen WWW-Seiten\n\n"
			   "Neben einer Steuerung mit der Maus ist auch eine Bedienung per Tastatur mglich,\n"
			   "mit der Tabulator-Taste kann zwischen den verschiedenen Schaltern gewechselt\n"
			   "werden, mit Return wird sie ausgewhlt, mit den Cursor-Tasten kann bei Listen darin\n"
			   "geblttert werden."
			   );
	yesno.Options("Schliessen");
	yesno.Start(mainwin);
}
int ende_sicher(void)
{
	yesno.Text("Wollen Sie wirklich 'panel'\nbeenden?");
	yesno.Options(" Ja | Nein ");
	return yesno.Start(mainwin)==1;
}
int main(int argc,char *argv[])
{
	int ende=0,r;
	mainwin.InitSize(0,0,450,100);
	if (!mainwin.Init(argc,argv)) //,"aquamarine3"))
	{
		printf("Error:\nCan't open display\n");
		exit(1);
	}
	
	maingp.Vert();
	maingp.Add(main2);
	 main2.Horiz();
	 main2.Add(sg1[0]);
	 main2.Add(main3);
	  main3.Vert();
	  main3.Add(kontrolle);
	  main3.Add(sg2[0]);
	maingp.Add(status);
	 status.Font(TGGFONT);
	 status.Text(" \n\n\n ");
	 status.Center();
	 status.HelpText("Hier werden Status-Informationen angezeigt.\n\n"
	 				 "panel, (c) 1996 by Jrgen Schmitz for FSAI\n"
	 				 "using Xclasses, the X11 programing library");
	 	 
	kontrolle.Horiz();
	kontrolle.Title("Kontrolle");
	kontrolle.Font(GPFONT);
	kontrolle.UseSmallest();
	kontrolle.Add(kontrollbut);
	 kontrollbut.Font(GGFONT);
	 kontrollbut.ID(1);
	 kontrollbut.Items(kbuts);
	 kontrollbut.HelpText("wechselt zwischen\nverschiedenen Modi");
	 xclock xc;
	 xc.NoMinutes();
	kontrolle.Add(xc);

	sg1[0].Weight(50); sg1[1].Weight(50);
	sg1[0].AddShadow(sg1[1]);
	sg1[0].Vert(); sg1[0].Font(GPFONT);
	for(int i=0;i<MAXBUTS;i++)
	{
		sg1[0].Add(b[i]);
		b[i].Font(GGFONT);
		b[i].ID(100+i);
		b[i].Text(btxt[i]);
		b[i].HelpText(htxt[i]);
	}

	sg1[1].Vert(); sg1[1].Font(GPFONT);
	sg1[1].Add(dir);
	 dir.Font(FIXGGFONT);
	 dir.ApplyInput(dir_in);
	 dir.SetDir(getenv("HOME"));
	 dir.GetDir(olddir,sizeof(olddir));
	 dir.DirsFirst();
	 dir.HelpText("Inhaltsverzeichnis des\ndarunten genannten Verzeichnisses");
	sg1[1].Add(dir_in);
	 dir_in.MaxChars(100);
	 dir_in.ID(10);
	 
	sg2[0].AddShadow(sg2[1]); //sg2[0].Font(GPFONT);
	sg2[0].AddShadow(sg2[2]); //sg2[1].Font(GPFONT);
	sg2[0].AddShadow(sg2[3]); //sg2[2].Font(GPFONT); sg2[3].Font(GPFONT);
	
	sg2[0].Vert();
	sg2[0].Add(ueber);
	 ueber.Font(SGGFONT);
	 ueber.AutoFormat();
	 ueber.Center();
	 ueber.Text("panel\nX11 Bedienungskonsole fr FSAI\n\n"
	 			"geschrieben mit Xclasses\n\n"
	 			"Infos zu jeder Programmfunktion erscheinen, wenn man den Mauszeiger ca. 2 Sekunden "
	 			"darauf stehen lt.");
	sg2[0].Add(anleitung);
	 anleitung.Font(SGGFONT);
	 anleitung.Text("Bedienungsanleitung");
	 anleitung.ID(11);
	 anleitung.Weight(10);
	 
	sg2[1].Vert();
	sg2[1].Add(cb1);
	 cb1.Font(GGFONT);
	 cb1.ID(201);
	 cb1.Text("Lschen");
	 cb1.HelpText("Lscht die in der Dateiliste angewhlte Datei");
	sg2[1].Add(cb2);
	 cb2.Font(GGFONT);
	 cb2.ID(202);
	 cb2.Text("Editieren");
	 cb2.HelpText("ffnet die in der Dateiliste angewhlte Datei\nin einem Text-Editor - nur sinnvoll bei Textdateien.");

	sg2[2].Vert();
	sg2[2].Add(wb1);
	 wb1.Font(GGFONT);
	 wb1.ID(301);
	 wb1.Text("Lschen");
	 wb1.HelpText("Lscht die in der Dateiliste angewhlte Datei");
	sg2[2].Add(wb2);
	 wb2.Font(GGFONT);
	 wb2.ID(302);
	 wb2.Text("Editieren");
	 wb2.HelpText("ffnet die in der Dateiliste angewhlte Datei\nin einem Texteditor.");
	sg2[2].Add(wb3);
	 wb3.Font(GGFONT);
	 wb3.ID(303);
	 wb3.Text("Freigeben");
	 wb3.HelpText("Setzt die Zugriffsrechte der in der Dateiliste gewhlten Datei\nso, dass sie von allen per WWW angesehen werden kann.");

	sg2[3].Horiz();
	sg2[3].Add(diskgp);
	 diskgp.Vert();
	 diskgp.Weight(75);
	 diskgp.Add(db1);
	  db1.Font(GGFONT);
	  db1.ID(401);
	  db1.Text("->");
	  db1.HelpText("Kopiert (links) ausgewhlte Datei auf Diskette.");
	 diskgp.Add(db2);
	  db2.Font(GGFONT);
	  db2.ID(402);
	  db2.Text("<-");
	  db2.HelpText("Kopiert (rechts) ausgewhlte Datei von Diskette.");
	 diskgp.Add(db3);
	  db3.Font(GGFONT);
	  db3.ID(403);
	  db3.Text("neue Disk\neinlesen");
	  db3.HelpText("erneutes Einlesen des Inhaltsverzeichnis\nder eingelegten Diskette");
	 diskgp.Add(db4);
	  db4.Font(GGFONT);
	  db4.ID(404);
	  db4.Text("Disk\nFile lschen");
	  db4.HelpText("Lscht die angewhlte Datei\nauf der Diskette.");

	sg2[3].Add(disk);	 
	 disk.Font(FIXGGFONT);
	 disk.Weight(150);
	 disk.ShowSelected();
	 disk.HelpText("Inhaltsverzeichnis\nder Diskette");
	
	mymenu.ID(1000);
	mymenu.AddMenu("Programm");
	mymenu.Add("Ende",1);

	mainwin.SetGroup(maingp);
	mainwin.SetMenu(mymenu);
	mainwin.Create();
	status.Text("panel\n(c) 1996 by Jrgen Schmitz\nusing Xclasses, the X11 class library");
	
	while (!ende)
	{
		r=mainwin.NextEvent();
		if (r==EV_WINDOWCLOSE)
		{
			if (mainwin.CloseMe() && ende_sicher()) ende=1;
		}
		else if (r==EV_GADGET)
		{
			switch (mainwin.ID())
			{
				case 1000:
					if (mymenu.MID()==1 && ende_sicher()) ende=1;
					break;
				case 1:
					status.Text("");
					if (kontrollbut.Selected()==KBUTS-1) ende=1;
					else if (kontrollbut.Selected()==0) { sg1[0].Show(); sg2[0].Show(); }
					else if (kontrollbut.Selected()==1) { sg1[1].Show(); sg2[1].Show(); if (md==3) dir.SetDir(olddir); md=1; }
					else if (kontrollbut.Selected()==3) { sg1[1].Show(); sg2[2].Show(); char buf[200]; strcpy(buf,getenv("HOME")); strcat(buf,"/public_html"); if (md==1 || md==2) { dir.GetDir(olddir,sizeof(olddir)); dir.SetDir(buf); } md=3; }
					else if (kontrollbut.Selected()==2) { sg1[1].Show(); sg2[3].Show(); if (md==3) dir.SetDir(olddir); md=2; }
					break;
				case 10: // input
					{
						char buf[100];
						dir_in.Input(buf);
						dir.SetDir(buf);
					}
					break;
				case 11:
					show_anleitung();
					break;
				case 100: // starten
				case 101:
				case 102:
				case 103:
				case 104:
				case 105:
					system(bcom[mainwin.ID()-100]);
					break;
				case 201: // files: lschen
					del_file();
					break;
				case 202: // edit
					run_edit();
					break;
				case 301: // www: lschen
					del_file();
					break;
				case 302: // edit
					run_edit();
					break;
				case 303: // frei
					www_frei();
					break;
				case 401: // disk: ->
					copy_to();
					break;
				case 402: // <-
					copy_from();
					break;
				case 403: // lesen
					read_disk();
					break;
				case 404: // lschen
					del_disk();
					break;

			}
		}
	}
	mainwin.Close();
}
